//
// C++ Interface: PlanTraining
//
// Description: 
//
//
// Author: Muylkens Toon <toon.muylkens@student.kuleuven.be>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
/**
 * \class PlanTraining
 *
 * \brief Provide an example
 *
 * This class is a QWidget, lets the user plan a training into the Planner
 *
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */



#ifndef PLANTRAINING_H
#define PLANTRAINING_H
#include "ui_PlanTraining.h"
#include "TrainingSchedule.h"
#include "StringCheck.h"
#include "ConfigFileHandlerPowerTraining.h"
#include "SelectExerciseWidget.h"
#include <QtCore/QDate>
#include "Training.h"
#include <QtGui/QPainter>
#include <QtGui/QMessageBox>

class PlanTraining : public QWidget
 {
     Q_OBJECT

 public:
        PlanTraining(QWidget *parent ,QDate date , ConfigFileHandlerPowerTraining *filehandler );

 private:
        Ui::PlanTraining ui;
	ConfigFileHandlerPowerTraining *filehandler;
	QList<TrainingSchedule*> traininglist;
	QMap<QString, QStringList> selectedExercises; ///schedulename, exercisesList
	void setValuesOfDates(QDate date);
	void fillComboBox();
	bool legalDay(QDate date);
	void editSchedule(QString schedulename);
private slots:
	void planTraining();
	void addSchedule();
	void removeSchedule();
	void editSchedule();
	void saveSchedule(QStringList list, QString schedulename);
	void moveUpSchedule();
	void moveDownSchedule();
public slots:
signals:
	void planTraining(Training *training, bool withsave);
};


#endif


