//
// C++ Implementation: Planner
//
// Description: 
//
//
// Author: Muylkens Toon <toon.muylkens@student.kuleuven.be>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "Planner.h"
// #include <stdio.h>
// #include <iostream>
// using namespace std;

Planner::Planner(QWidget *parent, ConfigFileHandlerPowerTraining *filehandler)
     : QCalendarWidget(parent)
{
this->filehandler=filehandler;
this->setGridVisible(true);
this->setVerticalHeaderFormat(QCalendarWidget::NoVerticalHeader);
QObject::connect(this,SIGNAL(clicked(QDate)),this,SLOT(dayClicked(QDate)));
}

/**
*starts a PlanTraining widget. A dialog for planning a training
*or if an existing training is planned on that day: ShowTraining dialog
*/
void Planner::dayClicked(QDate date){
if(!datesToPaint.contains(date)){
	planTraining(date);
}
else{
	Training *myTraining=filehandler->getTrainings().at(0);
	int size=filehandler->getTrainings().size();
	for(int i=0;i<size; i++){
	Training *temp = filehandler->getTrainings().at(i);
	if(temp->getDate()==date){
		 myTraining=filehandler->getTrainings().at(i);
		}
	}
	ShowTraining *show = new ShowTraining(0,myTraining, filehandler );
	QObject::connect(show,SIGNAL(deleteTraining(QDate)),filehandler,SLOT(deleteTraining(QDate)));
	QObject::connect(show,SIGNAL(deleteTraining(QDate)),this,SLOT(deleteTraining(QDate)));
	QObject::connect(show,SIGNAL(save()),filehandler,SLOT(savedata()));
	QObject::connect(show,SIGNAL(save()),this,SLOT(trainingChanged()));
	///QObject::connect(show,SIGNAL(save()),show,SLOT(close()));
	show->setWindowFlags(Qt::SubWindow);
	show->show();
}

}

/**
*emits the trainingChanged signal
*/
void Planner::trainingChanged(){
emit updateTrainingInformation();
}

/**
*remove training with date 'date' from datesToPaintList, tell InformationWidget to update itself
*tell PlannerWrap to update its listview.
*/
void Planner::deleteTraining(QDate date){
datesToPaint.removeAll(date);
emit updateTrainingInformation();
this->repaint();
this->hide();
this->show();
}

void Planner::planTraining(QDate date){
	PlanTraining *plan = new  PlanTraining(0,date, filehandler);
	QObject::connect(plan, SIGNAL(planTraining(Training*,bool)), this, SLOT(planTraining(Training*,bool)));
	plan->setWindowFlags(Qt::SubWindow);
	plan->show();
}

/**
*slot:the planTraining widget calls this slot when it want to plan a training, on its turn this widget wil call the PlannerWrap :-) good programming
*It also Paints the cell (so user sees the training was planed)
*/
void Planner::planTraining(Training *training, bool withsave){
if(!datesToPaint.contains(training->getDate())){datesToPaint.append(training->getDate());}
emit planTrainingSignal(training,withsave);
emit updateTrainingInformation();
this->repaint();
//this->setFocus(Qt::MouseFocusReason);
}

/**
*Overriden from QCalendarWidget, paints the cell different when a training is planned on that date.
*/
void Planner::paintCell(QPainter * painter, const QRect & rect, const QDate & date) const{
if(datesToPaint.contains(date) && date!=QDate::currentDate()){
QBrush brush = QBrush(Qt::SolidPattern);
brush.setColor(Qt::cyan);
painter->fillRect(rect,brush);
QString string = tr("Training\n" );
string.append(date.toString(QString("d")));
painter->drawText(rect,Qt::AlignCenter, string);
}
else if (datesToPaint.contains(date) && date==QDate::currentDate()){ 
QBrush brush1 = QBrush(Qt::SolidPattern);
brush1.setColor(Qt::red);
QBrush brush2 = QBrush(Qt::SolidPattern);
brush2.setColor(Qt::cyan);
QRect smallrect = QRect(rect);
smallrect.adjust(3,3,-3,-3);
painter->fillRect(rect,brush1);
painter->fillRect(smallrect,brush2);
QString string = tr("Training\n" );
string.append(date.toString(QString("d")));
//string.append("\nToday");
painter->drawText(rect,Qt::AlignCenter, string);
}

else if (!datesToPaint.contains(date) && date==QDate::currentDate()){ 
QBrush brush1 = QBrush(Qt::SolidPattern);
brush1.setColor(Qt::red);
QBrush brush2 = QBrush(Qt::SolidPattern);
brush2.setColor(Qt::white);
QRect smallrect = QRect(rect);
smallrect.adjust(3,3,-3,-3);
painter->fillRect(rect,brush1);
painter->fillRect(smallrect,brush2);
QString string = date.toString(QString("d"));
//string.append("\nToday");
painter->drawText(rect,Qt::AlignCenter, string);
}
else{
QBrush brush1 = QBrush(Qt::SolidPattern);
brush1.setColor(Qt::white);
painter->fillRect(rect,brush1);
QString string = date.toString(QString("d"));
painter->drawText(rect,Qt::AlignCenter, string);
//QCalendarWidget::paintCell(painter,rect,date);
}
}



void Planner::loadsettings(QList<QDate> list){
datesToPaint =list;
repaint();
//paintEvent(new QPaintEvent(QRect(0,0,300,300)));
}
