//
// C++ Interface: Planner
//
// Description: 
//
//
// Author: Muylkens Toon <toon.muylkens@student.kuleuven.be>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
/**
 * \class Planner
 *
 * \brief Provide an example
 *
 * This class is a QCallendar, but heavely extended. It is a training-plannner.
 * For long term planning of trainings.
 *
 * \note Nothing to note
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */


#ifndef PLANNER_H
#define PLANNER_H

#include <QtGui/QCalendarWidget>
#include <QtGui/QVBoxLayout>
#include "PlanTraining.h"
#include "ShowTraining.h"
#include "Training.h"
#include "ConfigFileHandlerPowerTraining.h"
#include <QtGui/QPaintEvent>
#include <QtCore/QList>
#include <QtGui/QPainter>
#include <QTextStream>

class Planner : public QCalendarWidget
 {
     Q_OBJECT
	
        public:
        Planner(QWidget *parent, ConfigFileHandlerPowerTraining *filehandler);
	void loadsettings(QList<QDate> datesToPaint);
	void paintCell(QPainter *painter, const QRect &rect, const QDate &date) const;
        private:
	QList<QDate> datesToPaint;
	ConfigFileHandlerPowerTraining *filehandler;
	private slots:
	void trainingChanged();
        public slots:
	void dayClicked(QDate date);
	void planTraining(QDate date);
	void planTraining(Training *training, bool withsave);
	void deleteTraining(QDate date); ///when training is deleted, delete it from datesToPaint list
        signals:
	void planTrainingSignal(Training *training, bool withsave);
	void updateTrainingInformation(); ///training added or deleted (or date changed or so)
};

#endif
