//
// C++ Implementation: PlannerWrap
//
// Description: 
//
//
// Author: Muylkens Toon <toon.muylkens@student.kuleuven.be>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "PlannerWrap.h"
// #include <stdio.h>
// #include <iostream>
// using namespace std;

PlannerWrap::PlannerWrap(QWidget *parent,ConfigFileHandlerPowerTraining *filehandler):QWidget(parent)
 {
	ui.setupUi(this);
	ui.hboxLayout->setContentsMargins (9,0,9,0 );
	this->filehandler=filehandler;
    	planner = new Planner(ui.groupBoxCalendar, filehandler);
	ui.vboxLayout->addWidget(planner);
	QObject::connect(planner, SIGNAL(planTrainingSignal(Training*, bool)),this,SLOT(planTraining(Training*,bool)));
	/*QObject::connect(planner, SIGNAL(trainingChanged()),parent->parent()->parent(),SLOT(updateTrainingInformation()));
	*/QObject::connect(planner,SIGNAL(updateTrainingInformation()),this,SLOT(trainingChanged()));

    	retranslateUi();
    	QMetaObject::connectSlotsByName(this);

	QObject::connect(ui.editButton, SIGNAL(pressed()),this,SLOT(editButtonPressed()));
	QObject::connect(ui.deleteButton, SIGNAL(pressed()),this,SLOT(deleteButtonPressed()));
	QObject::connect(ui.showButton, SIGNAL(pressed()),this,SLOT(showButtonPressed()));
	QObject::connect(ui.addButton, SIGNAL(pressed()),this,SLOT(planTraining()));
	
}

/**
*SLOT: when pressing edit button below the listWidget. ShowTraining Dialog is openend...
*same as the one for the Planner
*/
void PlannerWrap::editButtonPressed(){
if(ui.listWidget->currentRow() != -1){
	QList<Training*> list = filehandler->getTrainings();
	QList<Training> list2 =QList<Training>();
	for(int i=0;i<list.size();i++){
		if(list.at(i)->getDate()>=QDate::currentDate()){
			list2.append(*list.at(i));
			}
		}
	qSort(list2.begin(), list2.end());
	//const QDate dateOfSelectedTraining = list2.at(ui.listWidget->currentRow()).getDate();
	Training *myTraining = new Training(list2.at(ui.listWidget->currentRow())); ///pointer to copy of training to be edited
	filehandler->planTraining(myTraining,false); ///so we point to the real training,not the copy!
		
	ShowTraining *show = new ShowTraining(0,myTraining, filehandler );
	QObject::connect(show,SIGNAL(deleteTraining(QDate)),filehandler,SLOT(deleteTraining(QDate)));
	QObject::connect(show,SIGNAL(deleteTraining(QDate)),planner,SLOT(deleteTraining(QDate)));
	QObject::connect(show,SIGNAL(save()),filehandler,SLOT(savedata()));
	QObject::connect(show,SIGNAL(save()),this,SLOT(trainingChanged()));
	show->setWindowFlags(Qt::SubWindow);
	show->show();
	

}
}

void PlannerWrap::trainingChanged(){
fillListView();
emit updateTrainingInformation();
}

/**
*a training is deleted => tell listWidget and planner
*/
void PlannerWrap::deleteButtonPressed(){
if(ui.listWidget->currentRow() != -1){
	QList<Training*> list = filehandler->getTrainings();
	QList<Training> list2 =QList<Training>();
	for(int i=0;i<list.size();i++){
		if(list.at(i)->getDate()>=QDate::currentDate()){
			list2.append(*list.at(i));
			}
		}
	qSort(list2.begin(), list2.end());
	Training *myTraining = new Training(list2.at(ui.listWidget->currentRow())); ///pointer to copy of training to be deleted

	filehandler->deleteTraining(myTraining->getDate());
	planner->deleteTraining(myTraining->getDate());
	}
}

/**
*showbutton is pressed. same beheviour as pressing on an existing training in the planner and pressing SHOW afterwards
*/
void PlannerWrap::showButtonPressed(){
if(ui.listWidget->currentRow() != -1){
	QList<Training*> list = filehandler->getTrainings();
	QList<Training> list2 =QList<Training>();
	for(int i=0;i<list.size();i++){
		if(list.at(i)->getDate()>=QDate::currentDate()){
			list2.append(*list.at(i));
			}
		}
	qSort(list2.begin(), list2.end());
	Training *myTraining = new Training(list2.at(ui.listWidget->currentRow())); ///pointer to copy of training to be show
	
	TrainScheduleDisplayer *displayer =  new TrainScheduleDisplayer(0);
	displayer->setWindowFlags(Qt::SubWindow);
	displayer->setTraining(myTraining, filehandler);
	displayer->show();
}
}


void PlannerWrap::retranslateUi()
    {
    this->setWindowTitle(QApplication::translate("PlannerWrap", "MainWindow", 0, QApplication::UnicodeUTF8));
    } 

/**
*Start the PlanTraining dialog via the Planner With date=currentDate
*/
void PlannerWrap::planTraining(){
planner->planTraining(QDate::currentDate());
}

/**
*put training into the profile, and save when withsave=true
*/
void PlannerWrap::planTraining(Training *training ,bool withsave){
filehandler->planTraining(training,withsave);
planner->repaint();
fillListView();
}


void PlannerWrap::fillListView(){
ui.listWidget->clear();
QList<Training*> list = filehandler->getTrainings();
QList<Training> list2 =QList<Training>();
for(int i=0;i<list.size();i++){
	list2.append(*list.at(i));
	}
qSort(list2.begin(), list2.end());
for(int i=0;i<list2.size();i++){
	Training training = list2.at(i);
	if(training.getDate()>=QDate::currentDate()){
		QString text = training.getDate().toString("dddd d MMMM");
		text.append(" - ");
		text.append(training.getTitle());
		ui.listWidget->addItem(text);
		}
	}
}

/**
*This method makes the Planner widget represent the current status of planned trainings
*this method is probably executed when loading a new profile
*/
void PlannerWrap::loadsettings(ConfigFileHandlerPowerTraining *filehandler){
this->filehandler=filehandler;
QList<QDate> dateList = QList<QDate>();
for(int i=0; i<filehandler->getTrainings().size();i++){
Training *myTraining = filehandler->getTrainings().at(i);
dateList.append(myTraining->getDate());
}
planner->loadsettings(dateList);
fillListView();
}
