//
// C++ Interface: PowerTrainingMainWidget
//
// Description: 
//
//
// Author: Muylkens Toon <toon.muylkens@student.kuleuven.be>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
/**
 * \class PowerTrainingMainWidget
 *
 * \brief Provide an example
 *
 * This class is a QWidget. All It contains is a StackedWidget, which in his turn contains all the
 * Widgets needed for the PowerTraining part of Qtrainer. 
 *
 * \note Class was created to make MainWindow les crowded
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */

#ifndef POWERTRAININGMAINWIDGET_H
#define POWERTRAININGMAINWIDGET_H

 #include "ui_MainWidget.h"
#include <QtCore/QString>
#include <QtGui/QWidget>
#include <QtCore/QMutex>
#include <QtGui/QScrollArea>
#include <QtCore/QSettings>
#include "AddData.h"
#include "QtrainerPlotWidget.h"
#include "ViewAndManageSchedule.h" 
#include "Grid.h"
#include "ConfigFileHandlerPowerTraining.h"
#include "ExerciseHandler.h"
#include "ViewAndManageExercise.h"
#include "TrainScheduleDisplayer.h"
#include "CalculateProgress.h"
#include "PlannerWrap.h"
#include "QStringDates.h"
#include "InformationWidget.h"

class PowerTrainingMainWidget : public QWidget
 {
     Q_OBJECT
	
 public:
    	PowerTrainingMainWidget(ConfigFileHandlerPowerTraining *filehandler, QWidget *parent, QListWidget *leftList, QToolBar *toolBar);
	QList<QListWidgetItem*> getQListWidgetItem();
 private:
	///gui stuff
	InformationWidget *informationWidget;

// 	QGroupBox *groupBox_2;
//     	QGroupBox *actionsGroupBox;
// 	QLabel *progressLabel;
//     	QLabel *labelForum;
//     	QLabel *nextTrainingLabel;
//     	QLabel *profileLabel;
// 	QPushButton *showTrainingButton;
// 	QPushButton *addTestDataButton;
// 	QPushButton *addLatestScheduleButton;
	QToolBar *toolBar;

	///items
	QListWidget *leftList;
	QListWidgetItem *InformationItem;
	QListWidgetItem *AddDataItem; 
	QListWidgetItem *ViewDataPlottedItem;
	QListWidgetItem *ViewDataTabledItem;
	QListWidgetItem *ViewProgramsItem;
	QListWidgetItem *ViewExercisesItem;
	QListWidgetItem *ViewPlannerItem;
	
	///toolbar actions:
    	QAction *actionPlan_Training;
    	QAction *actionRemove_Training;
    	QAction *actionUpload;
    	QAction *actionAdd_Exercise;
    	QAction *actionAdd_Schedule;
    	QAction *actionSave_All;

	void resizeEvent(QResizeEvent * event);

	void makeQListWidgetItems();
	void makeActions();

 	Ui::MainWidget ui;

	bool active; ///true when this widget is active/shown

	AddData *adddatawidget;
	QScrollArea *scrollareaplot;
	QScrollArea *scrollareaadd;
	QScrollArea *scrollareaexercises;
	QScrollArea *scrollareaprograms;
	QtrainerPlotWidget *plotWidget;
	Grid *grid;
	ViewAndManageSchedule *programswidget;
	ViewAndManageExercise *exerciseswidget;
	PlannerWrap *plannerwidget;

	ConfigFileHandlerPowerTraining *filehandlerPowerTraining; ///filehandler for powertraining profiles
	
	QMutex *mutex_for_thread;
	bool isMessageBoxProgressAlreadyShown;
	
	void fillPlotWidget();

	Training *mostRecentTrainingInThePast;

private slots:
	void setToolBar(int stackIndex);
	void setconnections();
	void updateTrainingInformation();
	void setProgress(QString progressstring, QString numberstring);
	void askUserToTurnOfProgress();
	void showLatestTraining();
	void someTrainingScheduleChanged(QString oldName, TrainingSchedule *newschedule);
	void itemhasbeenchanged(QListWidgetItem *current);

	void updateTipInformation();
	QList<QString> getExercisesInNeedForTestData();
	void updateVisualisation();
	void updateVisualisation(int index);

	void storePlotMethod(QStringList list, int index);
	void storeNbPointsToPlot(int number,int index);

	void addExercise();
	void addTestDataButtonPressed();
	void addLatestScheduleButtonPressed();
	void showTestScheduleButtonPressed();
public slots:
	void loadsettings(ConfigFileHandlerPowerTraining *filehandlerPowerTraining);
	void updateInformation(int ExeciseThatRecievedANewDataPoint);
	void uploadButtonPressed();
	//void uploadPlots();
	void saveAllExercises();
	//void addExercise();
	void planTraining();
	void addTrainingSchedule();
	void updateScheduleInformation();

	void setCurrentIndex(int index); ///sets stackindex to 'index'
	void logout(); ///prepare for logout-gui-status
	void login(); ///prepare for login-gui-status
	void rescale(); ///triger this when the parent window got resised.
signals:
	void resizeWidgets();
	void upload();
	void updateToolBar();
	void setCurrentIndexInLeftFrame(int idx); ///the current index of the listWidget
	//void setToolBar(int index);
 };

#endif

