/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "PowerTrainingMeasurement.h"
// #include <stdio.h>
// #include <iostream>
// using namespace std;

PowerTrainingMeasurement::PowerTrainingMeasurement(int weight, int repetitions,StringDate date ,Exercise *exercise)/* : QObject(parent)*/
{
this->date = date;
this->myExercise = exercise;
this->weight = weight;
this->repetitions = repetitions;
this->normalisedWeight = normalize(this->repetitions,this->weight);
}

/**
*Returns the NOT normalised weight
*/
int PowerTrainingMeasurement::getWeight(){
return weight;
}

/**
*Returns the NOT normalised repetitions
*/
int PowerTrainingMeasurement::getRepetitions(){
return repetitions;
}


/**
*Returns the normalised Weight. 
*This is the weight used when the defaultValueForRepetitions is done
*/
int PowerTrainingMeasurement::getNormalisedWeight(){
return this->normalisedWeight;
}

/**
*Returns pointer to exercise this measurements is a measurement of :-)
*/
Exercise *PowerTrainingMeasurement::getExercise(){
return this->myExercise;
}

/**
*Returns the date the Measurement was taken.
*/
StringDate PowerTrainingMeasurement::getDate(){
return this->date;
}

/**
 * This method normalizes the weight you used to the weight you would have used when you did the default number
 * of repetitions
 * @param repetitions 
 * @param weight 
 * @return 
 */
 float PowerTrainingMeasurement::normalize(float repetitions, float weight)
 {
 float ricco = getExercise()->getNormaliseFactor(); ///linear approach: I plotted '%change in weight' in function of '%change in repetitions'
 float norm = getExercise()->getDefaultValueForRepetitions();
 float tussenresultaat=(repetitions-norm)*(ricco);
 float result = weight - (tussenresultaat*weight);
 return result;
 }


/**
 * @param weightused weight you used
 * @param repsdone the number of reps you did
 * @param nbReps the number of reps you want to know the weight of
 */
 float PowerTrainingMeasurement::normalize(float weightused,float repsdone, int nbReps)
 {
 float ricco = getExercise()->getNormaliseFactor(); ///linear approach: I plotted '%change in weight' in function of '%change in repetitions'
 float norm = nbReps;
 float tussenresultaat=(repsdone-norm)*(ricco);
 float result = weightused - (tussenresultaat*weightused);
 return result;
}



