//
// C++ Implementation: ScheduleOccurrence
//
// Description: 
//
//
// Author: Muylkens Toon <toon.muylkens@student.kuleuven.be>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "ScheduleOccurrence.h"
// #include <stdio.h>
// #include <iostream>
// using namespace std;

/**
*constructs a new ScheduleOccurrence
*@param scheduleName name of scheduleoccurrence, can't be changed after construction
*@param date date of scheduleoccurrence, can't be changed after construction
*@param exercises all exercises done,  can't be changed after construction
*@param weights all the weights in right order, as explained in the class documentation
*@param repetitions all the repetitions in right order, as explained in the class documentation
*/
ScheduleOccurrence::ScheduleOccurrence(QString scheduleName, QDate date,QStringList exercises, QList<int> weights, QList<int> repetitions)
 {
this->name=scheduleName;
this->date=date;
this->exercises=exercises;
this->weights=weights;
this->repetitions=repetitions;
 }

QDate ScheduleOccurrence::getDate() const {
return this->date;
}

QList<int> ScheduleOccurrence::getWeights() const {
return this->weights;
}

QList<int> ScheduleOccurrence::getRepetitions() const {
return this->repetitions;
}

QStringList ScheduleOccurrence::getExercises() const {
return this->exercises;
}

/**
*returns the name of the schedule this occurrence is from
*/
QString ScheduleOccurrence::getName() const {
return this->name;
}

void ScheduleOccurrence::setWeights(QList<int> weights){
this->weights=QList<int>(weights);
}

void ScheduleOccurrence::setRepetitions(QList<int> repetitions){
this->repetitions=QList<int>(repetitions);
}
	
bool ScheduleOccurrence::operator<(const ScheduleOccurrence &other) const{
 return getDate()<other.getDate();
}

/**
*date!name!_exercises_seperated_by_!_weights_seperated_by_!_repetitions_seperated_by_!
*/
QString ScheduleOccurrence::toString() const{
QString result;
result.append(StringDate(getDate()).getQString()+"!");
result.append(getName()+"!_");
for(int i=0;i<getExercises().size();i++){
	result.append(getExercises().at(i)+"_");
	}
result.append("!_");
for(int i=0;i<getWeights().size();i++){
	QString num; num.setNum(getWeights().at(i));
	result.append(num+"_");
	}
result.append("!_");
for(int i=0;i<getRepetitions().size();i++){
	QString num; num.setNum(getRepetitions().at(i));
	result.append(num+"_");
	}
result.append("!\n");
return result;
}
