/**
 * \class ScheduleOccurrence
 *
 * \brief Provide an example
 *
 * This class is a Schedule Occurence. So It contains all the weights, and repetitions.
 * they are orderd like this:
 * Looping over Rotations/Sets
 * Looping over exercises
 * Looping over the Iterations
 * Storing the value
 *
 * \note exerciseList,scheduleName,date can't be changed after construction!
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */
#ifndef SCHEDULEOCCURRENCE_H
#define SCHEDULEOCCURRENCE_H
#include <QDate>
#include <QStringList>
#include "QStringDates.h"

class ScheduleOccurrence
 {
public:
     	ScheduleOccurrence(QString scheduleName, QDate date,QStringList exercises, QList<int> weights, QList<int> repetitions);
	~ScheduleOccurrence() {};

	QDate getDate() const;
	QList<int> getWeights() const;
	QList<int> getRepetitions() const;
	QStringList getExercises() const;
	QString getName() const;
	void setWeights(QList<int> weights);
	void setRepetitions(QList<int> repetitions);
	
	bool operator<(const ScheduleOccurrence &t) const;
	
	QString toString() const;
private:

	QDate date;
	QList<int> weights;
	QList<int> repetitions;
	QStringList exercises;
	QString name;
 };

#endif
