/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "SelectExerciseWidget.h"
// #include <stdio.h>
// #include <iostream>
// 
// using namespace std;

/**
*constructor
* use this constructor if this widget is used as a stand-alone window (parent=0)
* It provides its own buttons for closing and 'ok' or 'show' ...
*@param forPrinting 
* 	| if true: The QWidget displays a button: show schedule, which sends a signal when clicked.
*	| if false: The QWidget is for saving the exercises into the Planner. So a save button is shown
*/
SelectExerciseWidget::SelectExerciseWidget(QWidget *parent,QString program, ConfigFileHandlerPowerTraining *filehandler, bool forPrinting)
     : QWidget(parent)
{
     	ui.setupUi(this);
	hboxLayout3 = new QHBoxLayout();
   	hboxLayout3->setObjectName(QString::fromUtf8("hboxLayout3"));
    	hboxLayout3->setContentsMargins(-1, 25, -1, -1);
   	closeButton = new QPushButton(tr("Close"),this);
	QObject::connect(closeButton,SIGNAL(pressed()),this, SLOT(close()));
   	closeButton->setObjectName(QString::fromUtf8("closeButton"));
    	hboxLayout3->addWidget(closeButton);
	QSpacerItem *spacerItem = new QSpacerItem(40, 20, QSizePolicy::Expanding, QSizePolicy::Minimum);
	hboxLayout3->addItem(spacerItem);
    	showButton = new QPushButton(tr("Show Schedule With Selected Exercises"),this);
   	showButton->setObjectName(QString::fromUtf8("showButton"));
	hboxLayout3->addWidget(showButton);
	ui.vboxLayout->addLayout(hboxLayout3);



	this->programname=program;
	this->filehandler=filehandler;
	this->integrated =false;
	selectedExercises = QList<QString>();
	notYetSelectedExercises = QList<QString>();
	if(forPrinting){
		QObject::connect(showButton,SIGNAL(pressed()),this,SLOT(showSchedule()));
		}
	ui.tagBox->addItems(filehandler->getExercise()->getPossibleExerciseTagList());
	ui.muscleBox->addItems(filehandler->getExercise()->getPossibleMuscleList());

	///fill notYetSelectedExercises
	for(int i=0;i<filehandler->getExercise()->getNbOfExercises();i++){
	int index = filehandler->getExercise()->getIndexes().at(i);
	notYetSelectedExercises.append(filehandler->getExercise()->getName(index));
	}
	fillLists();

	QObject::connect(ui.manuallyAddButton,SIGNAL(pressed()),this,SLOT(addManually()));
	QObject::connect(ui.removeButton,SIGNAL(pressed()),this,SLOT(removeSelected()));
	QObject::connect(ui.tagAddButton,SIGNAL(pressed()),this,SLOT(addByTag()));
	QObject::connect(ui.muscleAddButton,SIGNAL(pressed()),this,SLOT(addByMuscle()));

	if(!forPrinting){
		QObject::connect(showButton,SIGNAL(pressed()),this,SLOT(saveSchedule()));
		showButton->setText(tr("Ok"));
	}
}


/**
*constructor
* use this constructor if this widget is used as integrated window (parent!=0)
* It doens't provides its own buttons for closing and 'ok' or 'show' ...
*the schedulename 'has' to be set with setScheduleName() prior to
*when the signals showSchedule or saveSchedule are used.
*/
SelectExerciseWidget::SelectExerciseWidget(QWidget *parent, ConfigFileHandlerPowerTraining *filehandler) : QWidget(parent)
{
     	ui.setupUi(this);
	this->filehandler=filehandler;
	this->integrated=true;
	selectedExercises = QList<QString>();
	notYetSelectedExercises = QList<QString>();

	ui.tagBox->addItems(filehandler->getExercise()->getPossibleExerciseTagList());
	ui.muscleBox->addItems(filehandler->getExercise()->getPossibleMuscleList());

	///fill notYetSelectedExercises
	for(int i=0;i<filehandler->getExercise()->getNbOfExercises();i++){
	int index = filehandler->getExercise()->getIndexes().at(i);
	notYetSelectedExercises.append(filehandler->getExercise()->getName(index));
	}
	fillLists();

	QObject::connect(ui.manuallyAddButton,SIGNAL(pressed()),this,SLOT(addManually()));
	QObject::connect(ui.removeButton,SIGNAL(pressed()),this,SLOT(removeSelected()));
	QObject::connect(ui.tagAddButton,SIGNAL(pressed()),this,SLOT(addByTag()));
	QObject::connect(ui.muscleAddButton,SIGNAL(pressed()),this,SLOT(addByMuscle()));
}

/**
*Sets the schedule name to 'name'
*when using the 'integrated' constructor this  'has' to be set with setScheduleName() prior to
*when the signals showSchedule or saveSchedule are used.
*/
void SelectExerciseWidget::setScheduleName(QString name){
this->programname=name;
}

/**
*returns all the selected exercises by their name in a QStringList
*/
QStringList SelectExerciseWidget::getSelectedExercises(){
return QStringList(selectedExercises);
}

/**
*returns all the selected exercises by their index in a QList<int>
*/
// QList<int> SelectExerciseWidget::getSelectedExercisesInts(){
// return QList<int>(selectedExercises);
// }


/**
*refill lists, ... 
*/
void SelectExerciseWidget::loadsettings(ConfigFileHandlerPowerTraining *filehandler){
	this->filehandler=filehandler;
	ui.tagBox->addItems(filehandler->getExercise()->getPossibleExerciseTagList());
	ui.muscleBox->addItems(filehandler->getExercise()->getPossibleMuscleList());

	///clear selectedExercises
	selectedExercises.clear();
	///fill notYetSelectedExercises
	for(int i=0;i<filehandler->getExercise()->getNbOfExercises();i++){
	int index = filehandler->getExercise()->getIndexes().at(i);
	notYetSelectedExercises.append(filehandler->getExercise()->getName(index));
	}
	fillLists();

}


/**
*add all the exercises in 'names' to the selectedExercises-List if they exist.
*/
void SelectExerciseWidget::addByName(QStringList names){
for(int i=0;i<names.size();i++){
	if(filehandler->getExercise()->isAlreadyStored(names.at(i))){
		if(!selectedExercises.contains(names.at(i))){selectedExercises.append(names.at(i));}
		notYetSelectedExercises.removeAll(names.at(i));
		}
	}
fillLists();
}

/**
*Add all exercises to the list and the GUI with the currently selected muscle.
*/
void SelectExerciseWidget::addByMuscle(){
QString muscle = ui.muscleBox->currentText();
for(int i=0;i<filehandler->getExercise()->getNbOfExercises();i++){
	int index = filehandler->getExercise()->getIndexes().at(i);
	Exercise *ex = filehandler->getExercise()->getExercise(index);
	if(ex->getMuscleList().contains(muscle)){
		if(!selectedExercises.contains(ex->getName())){selectedExercises.append(ex->getName());}
		notYetSelectedExercises.removeAll(ex->getName());
		}
	}
fillLists();
}

/**
*Add all exercises to the list and the GUI with the currently selected tag.
*/
void SelectExerciseWidget::addByTag(){
QString tag = ui.tagBox->currentText();
for(int i=0;i<filehandler->getExercise()->getNbOfExercises();i++){
	int index = filehandler->getExercise()->getIndexes().at(i);
	Exercise *ex = filehandler->getExercise()->getExercise(index);
	if(ex->getTag()==tag){
		if(!selectedExercises.contains(ex->getName())){selectedExercises.append(ex->getName());}
		notYetSelectedExercises.removeAll(ex->getName());
		}
	}
fillLists();
}


/**
*Removes the selected exercise from the list and from the GUI listwidget
*/
void SelectExerciseWidget::removeSelected(){
int currentIndex = ui.selectedWidget->currentRow();
if(currentIndex !=-1){
	QString name = ui.selectedWidget->currentItem()->text();
	if(filehandler->getExercise()->isAlreadyStored(name)){
		selectedExercises.removeAll(name);
		if(!notYetSelectedExercises.contains(name)){notYetSelectedExercises.append(name);}
		fillLists();
		}
	}

}

/**
*Adds the currently selected exercise to the selected exercise list.
*In the GUI and in the underlying list.
*The exercise is removed from the notYetSelectedExercises-list.
*/
void SelectExerciseWidget::addManually(){
int currentIndex = ui.exercisesWidget->currentRow();
if(currentIndex !=-1){
	QString name = ui.exercisesWidget->currentItem()->text();
	if(filehandler->getExercise()->isAlreadyStored(name)){
		notYetSelectedExercises.removeAll(name);
		if(!selectedExercises.contains(name)){selectedExercises.append(name);}
		fillLists();
		if(currentIndex<ui.exercisesWidget->count()){ui.exercisesWidget->setCurrentRow(currentIndex);}
		else if(currentIndex >=ui.exercisesWidget->count()){ui.exercisesWidget->setCurrentRow(currentIndex-1);}
		}
	}
}

/**
*This method fills the lists in the GUI. The selected exercises and the notYetSelectedExercises.
*/
void SelectExerciseWidget::fillLists(){
ui.exercisesWidget->clear();
ui.selectedWidget->clear();
for(int i=0;i<selectedExercises.size();i++){
	ui.selectedWidget->addItem(selectedExercises.at(i));
	}
for(int i=0;i<notYetSelectedExercises.size();i++){
	ui.exercisesWidget->addItem(notYetSelectedExercises.at(i));
	}
}

/**
*This method closes this widget emits a signal to tell the Parent-Widget to open the ScheduleDisplayer
*/
void SelectExerciseWidget::showSchedule(){
emit showSchedule(selectedExercises, programname);
}

/**
*This method closes this widget emits a signal to tell the Parent-Widget the new
*list of exercises.
*'selectedOnes' contains all the names of the selected exercises
*/
void SelectExerciseWidget::saveSchedule(){
QStringList selectedOnes= QStringList(selectedExercises);
emit saveSchedule(selectedOnes, programname);
close();
}


