/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
/**
 * \class SelectExerciseWidget
 * \brief 
 * This QWidget lets the user select the exercises he/she wants to use in the already selected
 * training-schedule
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */
#ifndef SELECTEXERCISEWIDGET_H
#define SELECTEXERCISEWIDGET_H

#include "ui_SelectExerciseWidget.h"
#include "TrainScheduleDisplayer.h"
#include "ConfigFileHandlerPowerTraining.h"
#include <QtGui/QWidget>

class SelectExerciseWidget : public QWidget
 {
     Q_OBJECT

 public:
     	SelectExerciseWidget(QWidget *parent, QString program, ConfigFileHandlerPowerTraining *filehandler, bool forPrinting=true);
	SelectExerciseWidget(QWidget *parent, ConfigFileHandlerPowerTraining *filehandler);
	void addByName(QStringList names);
	void setScheduleName(QString name);
	void loadsettings(ConfigFileHandlerPowerTraining *filehandler);
	QStringList getSelectedExercises();
	//QList<int> getSelectedExercisesInts(); ///NEEDED?
 private:
     	Ui::SelectExerciseWidget ui;
	QList<QString> selectedExercises;///names of the exercises
	QList<QString> notYetSelectedExercises; ///names of the exercises
	QString programname;
	ConfigFileHandlerPowerTraining *filehandler;	

	void fillLists();
	bool integrated; ///which constructor was used?

	QHBoxLayout *hboxLayout3;
	QPushButton *showButton;
	QPushButton *closeButton;
private slots:
	void showSchedule();
	void saveSchedule();
	void addManually();
	void removeSelected();
	void addByTag();
	void addByMuscle();
signals:
	void showSchedule(QList<QString> selectedlist,QString programname); ///a list with ints, because it only needs to represent the right exercises for a short perio of time, in which no exercises are removed or so, which may cause the numbering to change.
	void saveSchedule(QStringList selectedlist,QString programname); ///list with names of exercises, because it still needs to represent the right exercises after removing some.
	
	

 };

#endif
