//
// C++ Implementation: PlanTraining
//
// Description: 
//
//
// Author: Muylkens Toon <toon.muylkens@student.kuleuven.be>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "ShowTraining.h"
// #include <stdio.h>
// #include <iostream>
// using namespace std;

ShowTraining::ShowTraining(QWidget *parent,Training *training, ConfigFileHandlerPowerTraining *filehandler)
     : QWidget(parent)
 {
        ui.setupUi(this);
	this->training =training;
	selectedExercises = training->getTrainingSchedulesMap();
	this->filehandler = filehandler;
	this->traininglist = QList<TrainingSchedule*>(filehandler->getTrainingSchedules());
	setValues();
	QObject::connect(ui.saveButton,SIGNAL(clicked()),this,SLOT(saveTraining()));
	QObject::connect(ui.deleteButton,SIGNAL(clicked()),this,SLOT(deleteTraining()));
	QObject::connect(ui.addScheduleButton,SIGNAL(clicked()),this,SLOT(addSchedule()));
	QObject::connect(ui.removeScheduleButton,SIGNAL(clicked()),this,SLOT(removeSchedule()));
	QObject::connect(ui.editScheduleButton,SIGNAL(clicked()),this,SLOT(editSchedule()));
	QObject::connect(ui.printButton,SIGNAL(clicked()),this,SLOT(printTraining()));

	QStringList list = QStringList();
	for(int i=0;i<traininglist.size();i++){
		if(!list.contains(traininglist.at(i)->getName())){
			///adding another possible trainingschedule to choose from
			list<<traininglist.at(i)->getName();
		}
	}
	ui.comboBox->clear();
	ui.comboBox->addItems(list);
	
	QObject::connect(ui.moveUpButton,SIGNAL(clicked()),this,SLOT(moveUpSchedule()));
	QObject::connect(ui.moveDownButton,SIGNAL(clicked()),this,SLOT(moveDownSchedule()));
 }

/**
*Move the selected training up one position in the list
*/
void ShowTraining::moveUpSchedule(){
if(ui.listWidget->currentRow() != -1 && ui.listWidget->currentRow() != 0){
	QList<QString> list = QList<QString>();
	for(int i=0;i<ui.listWidget->count();i++){
		list << ui.listWidget->item(i)->text();
		}
	list.swap(ui.listWidget->currentRow(),ui.listWidget->currentRow()-1);
	ui.listWidget->clear();
	for(int i=0;i<list.size();i++){
		ui.listWidget->addItem(list.at(i));
		}
	}
}

/**
*Move the selected training down one position in the list
*/
void ShowTraining::moveDownSchedule(){
if(ui.listWidget->currentRow() != -1 && ui.listWidget->currentRow() != ui.listWidget->count()-1){
	QList<QString> list = QList<QString>();
	for(int i=0;i<ui.listWidget->count();i++){
		list << ui.listWidget->item(i)->text();
		}
	list.swap(ui.listWidget->currentRow(),ui.listWidget->currentRow()+1);
	ui.listWidget->clear();
	for(int i=0;i<list.size();i++){
		ui.listWidget->addItem(list.at(i));
		}
	}
}


/**
*This calls the TrainingScheduleDisplayer, with all the schedules and selected exercises of this training.
*/
void ShowTraining::printTraining(){
TrainScheduleDisplayer *displayer =  new TrainScheduleDisplayer(0);
displayer->setWindowFlags(Qt::SubWindow);
displayer->hide();
 int ret = QMessageBox::question(this, tr("Save Training?"),tr("Do you want to save this training first?"), QMessageBox::Save | QMessageBox::Discard | QMessageBox::Cancel, QMessageBox::Save);
switch (ret) 
	{
	case QMessageBox::Save:
	saveTraining();
	displayer->setTraining(training, filehandler);
	displayer->show();
	break;
	case QMessageBox::Discard:
	///don't save
	displayer->setTraining(training, filehandler);
	displayer->show();
	break;
	case QMessageBox::Cancel:
	///do nothing
	break;
	}

}

/**
*Alter the Selected exercise list for this schedule.
*\note the param schedulename is the name of the schedule, not the training
*/
void ShowTraining::editSchedule(QString schedulename){
SelectExerciseWidget *selectExerciseWidget = new SelectExerciseWidget(0,schedulename,filehandler, false);
selectExerciseWidget->setWindowFlags(Qt::SubWindow);
QObject::connect(selectExerciseWidget, SIGNAL(saveSchedule(QStringList,QString)),this, SLOT(saveSchedule(QStringList,QString)));
selectExerciseWidget->addByName(selectedExercises.value(schedulename));
selectExerciseWidget->show();
}


/**
*Alter the Selected exercise list for this schedule.
*/
void ShowTraining::editSchedule(){
if(ui.listWidget->currentRow() != -1){
	editSchedule(ui.listWidget->currentItem()->text());
	}
}

/**
*This SLOT saves the selected exercises of the given schedule with 'schedulename' into this Training.
*/
void ShowTraining::saveSchedule(QStringList list, QString schedulename){
selectedExercises.insert(schedulename,list);
}


void ShowTraining::setValues(){
	ui.lineEdit->setText(training->getTitle());
 	ui.timeEdit->setTime(training->getStartTime());
 	ui.timeEdit_2->setTime(training->getEndTime());
	ui.textEdit->setText(training->getExplaination());
	ui.listWidget->addItems(training->getTrainingSchedules());	
}

/**
*Add the selected trainingschedule to the list
*/
void ShowTraining::addSchedule(){
if(ui.comboBox->currentIndex() != -1){
	QString text= ui.comboBox->currentText();
	ui.listWidget->addItem(text);
	editSchedule(text);
	}
}


/**
*Remove the selected trainingschedule from the list
*/
void ShowTraining::removeSchedule(){
if(ui.listWidget->currentRow() != -1){
	selectedExercises.remove(ui.listWidget->currentItem()->text());
	ui.listWidget->takeItem(ui.listWidget->currentRow());
	}
}


void ShowTraining::deleteTraining(){
emit deleteTraining(training->getDate());
this->close();
}

void ShowTraining::saveTraining(){
bool nameOK = StringCheck::check(ui.lineEdit->text(),false,tr("The name you entered has illegal\n characters in it or is empty."));
bool explanationOK = StringCheck::check(ui.textEdit->toPlainText(),true,tr("The explanation you entered has illegal characters in it."));
if(explanationOK && nameOK){
	training->setTitle(ui.lineEdit->text());
	training->setStartTime(ui.timeEdit->time());
	training->setEndTime(ui.timeEdit_2->time());
	QString explanation = ui.textEdit->toPlainText();
	explanation.replace(QString("\n"), "  ");
	training->setExplaination(explanation);
	training->setTrainingSchedules(selectedExercises);
		QList<QString> orderList = QList<QString>();
		for(int i=0;i<ui.listWidget->count();i++){
		orderList.append(ui.listWidget->item(i)->text());
		}
	training->setOrderList(orderList);

	emit save();
	close();	
}
}
