//
// C++ Interface: PlanTraining
//
// Description: 
//
//
// Author: Muylkens Toon <toon.muylkens@student.kuleuven.be>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
/**
 * \class ShowTraining
 * \brief Provide an example
 *
 * This class is a QWidget, lets the user modify a training from the Planner
 * Or just shows the user information about that training
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 * \note What's this class doing here when we already have PlanTraining ??!
 */



#ifndef SHOWTRAINING_H
#define SHOWTRAINING_H
#include "ui_ShowTraining.h"
#include "TrainingSchedule.h"
#include "TrainScheduleDisplayer.h"
#include <QtCore/QDate>
#include "Training.h"
#include "StringCheck.h"
#include <QtGui/QPainter>
#include <QtGui/QMessageBox>
#include "SelectExerciseWidget.h"
#include "ConfigFileHandlerPowerTraining.h"

class ShowTraining : public QWidget
 {
     Q_OBJECT

 public:
        ShowTraining(QWidget *parent,Training *training,ConfigFileHandlerPowerTraining *filehandler);

 private:
        Ui::ShowTraining ui;
	ConfigFileHandlerPowerTraining *filehandler;
	void setValues();
	Training *training;
	QList<TrainingSchedule*> traininglist;
	QMap<QString, QStringList> selectedExercises; ///schedulename, exercisesList

	void editSchedule(QString schedulename);
private slots:
	void saveTraining();
	void deleteTraining();
	void addSchedule();
	void removeSchedule();
	void editSchedule();
	void saveSchedule(QStringList list, QString schedulename);
	void printTraining();
	void moveUpSchedule();
	void moveDownSchedule();
signals:
	void deleteTraining(QDate date); ///Date of this training
	void save();
};


#endif


