/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "TableWidget.h"
  #include <stdio.h>
  #include <iostream>
  using namespace std;

TableWidgetOfTestData::TableWidgetOfTestData(QWidget *parent, ConfigFileHandlerPowerTraining *filehandler)
     : QWidget(parent)
{
	busytabling=false;
     	ui.setupUi(this);
	ui.vboxLayout->setContentsMargins (9,0,9,0 );
	this->filehandler=filehandler;
	nameitemlist = new QList<QTableWidgetItem*>();
	weightitemlist = new QList<QTableWidgetItem*>();
	repetitionitemlist = new QList<QTableWidgetItem*>();
	dateitemlist = new QList<DateTableWidgetItem*>();

	QObject::connect(ui.tableWidget,SIGNAL(cellChanged(int,int)),this,SLOT(cellChanged(int,int)));
}

/**
*This slot saves the new values in the profile.
*/
void TableWidgetOfTestData::cellChanged(int row ,int collumn){
if(!busytabling){
///weight
	QString exercisename = ui.tableWidget->item(row,0)->text();
	StringDate SDate = StringDate(ui.tableWidget->item(row,1)->text());  ///-> die kollom is er nog niet bij constructie

	int weight = ui.tableWidget->item(row,2)->text().toInt();
	int quantity = ui.tableWidget->item(row,3)->text().toInt();
	filehandler->appenddata(exercisename,weight,quantity,SDate.getQDate());
	emit someCellChanged();	

	QMessageBox msgBox;
	msgBox.setIcon(QMessageBox::Information);
	msgBox.setStandardButtons(QMessageBox::Ok);
	msgBox.setText(tr("Datapoint was edited and saved into the QProfile"));
	msgBox.exec();
}
}


/**
 * swaps the colour between two colours, this is being used for example to have every
 * exercise display differently on a table
 * @return 
 */
QBrush TableWidgetOfTestData::swapbrush(QBrush brush)
{
if(brush.color()==Qt::white){brush.setColor(QColor(232,232,232));}
else {brush.setColor(Qt::white);}
return brush;
}

void TableWidgetOfTestData::tableall()
{
if(!busytabling){
busytabling=true;
ui.tableWidget->clear();
ui.tableWidget->setRowCount(0);

QTableWidgetItem *__colItem = new QTableWidgetItem(tr("Name"));
ui.tableWidget->setHorizontalHeaderItem(0, __colItem);

QTableWidgetItem *__colItem1 = new QTableWidgetItem(tr("Date"));
ui.tableWidget->setHorizontalHeaderItem(1, __colItem1);

QTableWidgetItem *__colItem2 = new QTableWidgetItem(tr("Weight"));
ui.tableWidget->setHorizontalHeaderItem(2, __colItem2);

QTableWidgetItem *__colItem3 = new QTableWidgetItem(tr("Repetitions"));
ui.tableWidget->setHorizontalHeaderItem(3, __colItem3);


// int i=ui.tableWidget->rowCount(); 
// while(i !=0)
// {
// i--; 
// int index = ui.tableWidget->rowCount()-1;
// cout<<"index: "<<index<<endl;
// ui.tableWidget->removeRow(index);
// } ///REMOVE OLD DATA
nameitemlist->clear();
weightitemlist->clear();
repetitionitemlist->clear();
dateitemlist->clear();
// QList<QString> listnames = filehandler->getnames();
// QList<QString>	listdates = filehandler->getdates();
// QList<int> listweights = filehandler->getweights();
// QList<int> listrepetitions = filehandler->getrepetitions();


QBrush brush = QBrush(QColor(232,232,232), Qt::SolidPattern);
for (int i=0;i<filehandler->getExercise()->getNbOfExercises();i++)
{
	int indexOfEx = filehandler->getExercise()->getIndexes().at(i);
	///loop over exercises
	brush=swapbrush(brush);
	Exercise *ex = filehandler->getExercise()->getExercise(indexOfEx);
	QString name = ex->getName();
	QList<PowerTrainingMeasurement*> list  = ex->getMeasurements();
	for(int j=list.size()-1;j>-1;j--){
		int index = ui.tableWidget->rowCount();
		///loop over measurements of test values
		ui.tableWidget->insertRow(index); ///Make new row!!!
		nameitemlist->insert(index, new QTableWidgetItem(name));
// 		nameitemlist->at(i)->setText(name);
		nameitemlist->at(index)->setBackground(brush);
		nameitemlist->at(index)->setFlags(Qt::ItemIsEnabled);
		ui.tableWidget->setItem(index,0,nameitemlist->at(index));
	
		dateitemlist->insert(index, new DateTableWidgetItem(list.at(j)->getDate().getQString()));
		dateitemlist->at(index)->setBackground(brush);
		dateitemlist->at(index)->setFlags(Qt::ItemIsEnabled);
		ui.tableWidget->setItem(index,1,dateitemlist->at(index));

		
		weightitemlist->insert(index,new QTableWidgetItem());
		int wi = list.at(j)->getWeight();QString ws;ws.setNum(wi);
		weightitemlist->at(index)->setText(ws);
		weightitemlist->at(index)->setBackground(brush);
		weightitemlist->at(index)->setFlags(Qt::ItemIsEditable | Qt::ItemIsSelectable | Qt::ItemIsEnabled);
		ui.tableWidget->setItem(index,2,weightitemlist->at(index));

		repetitionitemlist->insert(index,new QTableWidgetItem());
		int ri = list.at(j)->getRepetitions();QString rs;rs.setNum(ri);
		repetitionitemlist->at(index)->setText(rs);
		repetitionitemlist->at(index)->setBackground(brush);
		repetitionitemlist->at(index)->setFlags(Qt::ItemIsEditable  | Qt::ItemIsSelectable | Qt::ItemIsEnabled);
		ui.tableWidget->setItem(index,3,repetitionitemlist->at(index));

	///Not strictly nessecary
	///ui.tableWidget->sortItems(0, Qt::AscendingOrder);
	QObject::disconnect(ui.tableWidget->horizontalHeader(), SIGNAL(sectionPressed(int)),ui.tableWidget,SLOT(selectColumn(int)));
	QObject::connect(ui.tableWidget->horizontalHeader(),SIGNAL(sectionClicked(int)), this, SLOT(sortTable(int)));
	///ui.tableWidget->setSortingEnabled(true);
			

		}
}
busytabling=false;
}


/*
	QString newname,previousname; ///Name of the previous and the current exercise being listed in the table
	QBrush brush = QBrush(QColor(232,232,232), Qt::SolidPattern);
	for (int i=0;i<filehandler->getExercise()->getNbOfExercises();i++)
	{
	Exercise *ex = filehandler->getExercise()->getExercise(i);
	
	ui.tableWidget->insertRow(i); ///Make new row!!!	

	///set a different colour for new exercises.
	newname = listnames.at(i);
	if(previousname!=newname){brush=swapbrush(brush);}
	previousname=newname;
	
	nameitemlist->insert(i, new QTableWidgetItem());
	nameitemlist->at(i)->setText(filehandler->getExercise()->getName(i));
	nameitemlist->at(i)->setBackground(brush);
	nameitemlist->at(i)->setFlags(Qt::ItemIsEnabled);
	ui.tableWidget->setItem(i,0,nameitemlist->at(i));
	
	dateitemlist->insert(i, new DateTableWidgetItem(listdates.at(i)));
	//dateitemlist->at(i)->setText(listdates.at(i));
	dateitemlist->at(i)->setBackground(brush);
	dateitemlist->at(i)->setFlags(Qt::ItemIsEnabled);
	ui.tableWidget->setItem(i,1,dateitemlist->at(i));
		
	weightitemlist->insert(i,new QTableWidgetItem());
	int wi = listweights.at(i);QString ws;ws.setNum(wi);
	weightitemlist->at(i)->setText(ws);
	weightitemlist->at(i)->setBackground(brush);
	weightitemlist->at(i)->setFlags(Qt::ItemIsEditable | Qt::ItemIsSelectable | Qt::ItemIsEnabled);
	ui.tableWidget->setItem(i,2,weightitemlist->at(i));

	repetitionitemlist->insert(i,new QTableWidgetItem());
	int ri = listrepetitions.at(i);QString rs;rs.setNum(ri);
	repetitionitemlist->at(i)->setText(rs);
	repetitionitemlist->at(i)->setBackground(brush);
	repetitionitemlist->at(i)->setFlags(Qt::ItemIsEditable  | Qt::ItemIsSelectable | Qt::ItemIsEnabled);
	ui.tableWidget->setItem(i,3,repetitionitemlist->at(i));

	///Not strictly nessecary
	///ui.tableWidget->sortItems(0, Qt::AscendingOrder);
	QObject::disconnect(ui.tableWidget->horizontalHeader(), SIGNAL(sectionPressed(int)),ui.tableWidget,SLOT(selectColumn(int)));
	QObject::connect(ui.tableWidget->horizontalHeader(),SIGNAL(sectionClicked(int)), this, SLOT(sortTable(int)));
	///ui.tableWidget->setSortingEnabled(true);
	}//closes for lus
busytabling=false;*/
}


void TableWidgetOfTestData::sortTable(int collumn){
busytabling=true;
ui.tableWidget->sortItems(collumn, Qt::DescendingOrder);
QString newname,previousname; ///Name of the previous and the current exercise being listed in the table
QBrush brush = QBrush(Qt::cyan, Qt::SolidPattern);
int i=ui.tableWidget->rowCount();
while(i !=0){
	i--; 
	///set a different colour for new exercises.
	newname = ui.tableWidget->item(i,0)->text();
	if(previousname!=newname){brush=swapbrush(brush);}
	for(int k=0;k<ui.tableWidget->columnCount();k++){
	ui.tableWidget->item(i,k)->setBackground(brush);
	}
	previousname=newname;
	}
busytabling=false;
	
}

void TableWidgetOfTestData::loadsettings(ConfigFileHandlerPowerTraining *filehandler)
{
this->filehandler=filehandler;
while(ui.tableWidget->rowCount()!=0) {ui.tableWidget->removeRow(0);}
redraw();
}

/**
 * Execute when data-Points have been inserted, so we need to reload the data and redraw it in the table
 */
void TableWidgetOfTestData::redraw()
{
tableall();
}

/**
 *Execute when data-Points have been inserted, so we need to reload the data and redraw it in the table
* this time as a slot, made for being able to add just one row instead of reloading the whole table, after adding a datapoint
*at the moment this executes redraw()
 */
void TableWidgetOfTestData::redraw(int i)
{
redraw();
}
