/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
/**
 * \class TableWidget
 *
 * \brief Provide an example
 *
 * Shows all the train-data in table form
 *
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */

#ifndef TABLEWIDGETOFTESTDATA_H
#define TABLEWIDGETOFTESTDATA_H



#include "ui_TableWidget.h"
#include "ConfigFileHandlerPowerTraining.h"
#include "QStringDates.h"
#include "DateTableWidgetItem.h"
#include <QApplication>
#include <QtGui/QWidget>
#include <QtCore/QSettings>
#include <QtGui/QTableWidgetItem>
#include <QtCore/QList>
#include <QtGui/QHeaderView>
#include <QMessageBox>
class TableWidgetOfTestData : public QWidget
 {
     Q_OBJECT

 public:
     	TableWidgetOfTestData(QWidget *parent = 0, ConfigFileHandlerPowerTraining *filehandler=0);
	void loadsettings(ConfigFileHandlerPowerTraining *filehandler);

 private:
     	Ui::TableWidgetOfTestData ui;
	void tableall();
	ConfigFileHandlerPowerTraining *filehandler;
	QList<QTableWidgetItem*> *nameitemlist;
	QList<QTableWidgetItem*> *weightitemlist;
	QList<QTableWidgetItem*> *repetitionitemlist;
	QList<DateTableWidgetItem*> *dateitemlist;
	QBrush swapbrush(QBrush brush);

	void sort( int column, Qt::SortOrder order = Qt::AscendingOrder );
	bool busytabling;
public slots:
	void redraw(int i);
	void redraw();

private slots:
	void sortTable(int collumn);
	void cellChanged(int row ,int collumn);
	
signals:
	void someCellChanged();
	

 };
#endif
