/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
/**
 * \class TrainScheduleDisplayer
 *
 * \brief Provide an example
 *
 * This class is a QWidget. It shows a TrainingSchedule or a whole Training in HTML form.
 *
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */
#ifndef TRAINSCHEDULEDISPLAYER_H
#define TRAINSCHEDULEDISPLAYER_H




#include "ui_TrainScheduleDisplayer.h"
#include "ConfigFileHandlerPowerTraining.h"
#include "Training.h"
#include <QApplication>
#include <QtGui/QWidget>
#include <QtCore/QSettings>
#include <QtGui/QPrintDialog>
#include <QtGui/QPrinter>
#include <QtGui/QPixmap>
#include <QtGui/QPrinter>
#include <QtCore/QRect>
#include <QtCore/QSize>
#include <QtGui/QPainter>

class TrainScheduleDisplayer : public QWidget
 {
     Q_OBJECT

 public:
     	TrainScheduleDisplayer(QWidget *parent = 0);
	void setSchedule(QString program, ConfigFileHandlerPowerTraining *filehandler,QList<QString> allowedExercisesList);
	QString addExcercise(QString text, int rotation, QString excersisename, int repetitions, int performance, ConfigFileHandlerPowerTraining *filehandler);
	void setTraining(Training *training, ConfigFileHandlerPowerTraining *filehandler);
	
 private:
     	Ui::TrainScheduleDisplayer ui;
	TrainingSchedule *schedule;
	//QPrintDialog *printDialog;
	QPrinter *printer;
	//QPainter painter;
	int numberOfExercises;
	int numberOfCharacters;
	int numberOfSchedules;
	QString addSchedule(QString text, QString schedulename, ConfigFileHandlerPowerTraining *filehandler, QList<QString> allowedExercisesList, bool resetNbOfExercisesAndCharactersAndSchedules=true);
private slots:
	void print();
	
signals:
	
	

 };

#endif
