//
// C++ Implementation: Training
//
// Description: 
//
//
// Author: Muylkens Toon <toon.muylkens@student.kuleuven.be>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "Training.h"
// #include <stdio.h>
// #include <iostream>
// using namespace std;

/**
*constructs a new Training
*@param scheduleMap contains the exercises selected for every schedule.
*@param orderList contains all the schedules. But is order preserving.
*/
Training::Training(QMap<QString, QStringList> scheduleMap,QList<QString> orderList, QDate date,QTime start, QTime end, QString title,QString explaination )
 {
this->scheduleMap = scheduleMap;
this->orderList = orderList;
this->date=date;
this->start=start;
this->end=end;
this->title=title;
this->explaination=explaination;
 }

Training::Training(const Training &other )
 {
this->scheduleMap = other.getTrainingSchedulesMap();
this->orderList = other.getOrderList();
this->date=other.getDate();
this->start=other.getStartTime();
this->end=other.getEndTime();
this->title=other.getTitle();
this->explaination=other.getExplaination();
 }


QStringList Training::getOrderList() const{
return QStringList(this->orderList);
}

QDate Training::getDate() const{
return date;
}

QTime Training::getStartTime() const{
return start;
}

QTime Training::getEndTime() const{
return end;
}

QString Training::getTitle() const{
return title;
}

QString Training::getExplaination() const{
return explaination;
}

/**
*Return the names of all the schedules of this Training
*Returns them in order specified bij 'orderList' paramater in constructor or setter.
*/
QStringList Training::getTrainingSchedules() const{
return QStringList(orderList);
}


/**
*Return the names of all the schedues of this Training and their corresponding selected exercises.
*selected exercises named by name
*/
QMap<QString,QStringList> Training::getTrainingSchedulesMap() const{
return QMap<QString,QStringList>(scheduleMap);
}

/**
*Rename all the Schedules with name 'oldName' to 'newname' in This Training (so not the schedule itself)
*/
void Training::renameTrainingSchedules(QString oldName,QString newname){
/*cout<<"renaming this training"<<endl;
cout<<scheduleMap.size() <<endl;*/
QMutableMapIterator<QString,QStringList> i(scheduleMap);
while (i.hasNext()) {
	i.next();
	if(i.key()==oldName){
/*		cout<<"OK"<<endl;*/
		QStringList temp = QStringList(i.value());
		i.remove();
// 		cout<<scheduleMap.size() <<endl;
		scheduleMap.insert(newname,temp);
// 		cout<<scheduleMap.size() <<endl;
/*		cout<<"DONE"<<endl;*/
		}
 	}

for(int j=0;j<orderList.size();j++){
	if(orderList.at(j) == oldName){
		orderList.replace(j,newname);
		}
}

// QTextStream cout(stdout, QIODevice::WriteOnly);
// QMapIterator<QString,QStringList> j(scheduleMap);
// while (j.hasNext()) {
// 	j.next();
// 	cout<<j.key()<<endl;;
//  }

}
 


QString Training::toString(){
QString result;
result.append(StringDate(getDate()).getQString()+"!");
result.append(getStartTime().toString("hh:mm")+"!");
result.append(getEndTime().toString("hh:mm")+"!");
result.append(getTitle()+"!");
result.append(getExplaination()+"!");
for(int i=0;i<orderList.size();i++){
	result.append("_"+orderList.at(i)+"_");
	QStringList exerciseList = scheduleMap.value(orderList.at(i));
	for(int i=0;i<exerciseList.size();i++){
		result.append(exerciseList.at(i)+"_");
		}
	result.append("!");
}
/*
QMapIterator<QString, QStringList> i(scheduleMap);
while (i.hasNext()) {
	i.next();
	result.append("_"+i.key()+"_");
	QStringList exerciseList = i.value();
	for(int i=0;i<exerciseList.size();i++){
		result.append(exerciseList.at(i)+"_");
		}
	result.append("!");
 }*/

return result;
}

void Training::setStartTime(QTime start){
this->start = start;
}

void Training::setEndTime(QTime end){
this->end = end;
}

void Training::setTitle(QString title){
this->title = title;
}

void Training::setExplaination(QString explaination){
this->explaination = explaination;
}

void Training::setTrainingSchedules(QMap<QString, QStringList> map){
this->scheduleMap= map;
}

void Training::setOrderList(QList<QString> orderList){
this->orderList=orderList;
}


bool Training::operator<(const Training &other) const
{
   return getDate()<other.getDate();
}
