//
// C++ Interface: Training
//
// Description: 
//
//
// Author: Muylkens Toon <toon.muylkens@student.kuleuven.be>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
/**
 * \class Training
 *
 * \brief Provide an example
 *
 * This class is a training-moment. It contains information about this training
 *
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */
#ifndef TRAINING_H
#define TRAINING_H
#include <QTime>
#include <QDate>
#include <QStringList>
#include <QMap>
#include "QStringDates.h"
#include <QTextStream>

class Training
 {
public:
     	Training(QMap<QString,QStringList> trainingSchedules,QList<QString> orderList, QDate date=QDate::currentDate(), QTime start=QTime::currentTime(), QTime end=QTime::currentTime(), QString title="", QString explaination="");
	Training(const Training &other);
	~Training() {};

	QDate getDate() const;
	QTime getStartTime() const;
	QTime getEndTime() const;	
	QString getTitle() const;
	QString getExplaination() const;
	QStringList getTrainingSchedules() const;
	QMap<QString,QStringList> getTrainingSchedulesMap() const;
	QStringList getOrderList() const;

	void setStartTime(QTime start);
	void setEndTime(QTime end);
	void setTitle(QString title);
	void setExplaination(QString explaination);
	void setTrainingSchedules(QMap<QString, QStringList> map);
	void setOrderList(QList<QString> orderList);

	bool operator<(const Training &t) const;
	
	QString toString();

	void renameTrainingSchedules(QString oldName,QString newname);
private:

	QDate date;
	QTime start;
	QTime end;
	QString title;
	QString explaination;
	QMap<QString,QStringList> scheduleMap;
	QList<QString> orderList;
 };

#endif
