//
// C++ Implementation: Training
//
// Description: 
//
//
// Author: Muylkens Toon <toon.muylkens@student.kuleuven.be>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "TrainingSchedule.h"
// #include <stdio.h>
// #include <iostream>
// 
// using namespace std;

/**
*constructs a new TrainingSchedule with the given name and explaination.
*The explaination can later be changed. The name not!
*/
TrainingSchedule::TrainingSchedule(QString name, QString explaination)
 {
this->name=name;
this->explaination=explaination;
performanceList = new QList<QList<int>* >();
numberOfTimesExerciseIsDoneList = new QList<QList<int>* >();
 }

/**
*this method sets the explaination to newExplaination.
*@post getExplaination() == newExplaination
*/
void TrainingSchedule::setExplaination(QString newExplaination){
explaination=newExplaination;
}

/**
*this method sets the explaination to newName.
*@post getName() == newName
*/
void TrainingSchedule::setName(QString newName){
name=newName;
}


/**
*This method sets the number of rotations to 'i'
*@post getNumberOfRotations() == i
*The number of rotations is the number of times the schedule is done.
*for example in schedule: 2*(3*A+3*B+3*C) with A, B, C exercises
*this schedule has 2 Rotations. Every rotation exercise A,B,C is done 3 times, right after each other.
*\note. Unlike addRotation, no iterations are added automaticly!
*/
void TrainingSchedule::setNumberOfRotations(int i){
numberOfRotations=i;
}


/**
*This method sets the performance of rotation 'rotation' and repetition 'repetition' to 'performance'
*A performance is a percent. 0<=performance<=100
*100% is when you have to go to your maximum to be able to do the exercise with the given weight and given repetitions.
*\note The exercises in Qtrainer are plotted this way: the weight used when doing the exercise with
*100% performance and doing the exercise 10 times.
*@post getPerformance(rotation,repetition) == performance
*@param rotations start counting from 0
*@param repetition start counting from 0
*@returns 
* | true when succesfull
* | false when rotation or repetition for that rotation doesn't exist.
* | false when performance is smaller then 10.
* | false when performance is bigger then 100.
*/
bool TrainingSchedule::setPerformance(int rotation, int repetition, int performance){
if(performance<10){return false;}
else if(performance>100){return false;}
else if(rotation >= performanceList->size()){return false;}
else if(repetition >= performanceList->at(rotation)->size()){return false;}
else{
QList<int> *list = performanceList->at(rotation);
list->replace(repetition,performance);
return true;
}
return true;
}

/**
*This method sets the number of times an exercise is done in rotation 'rotation' and repetition 'repetition' to 'number'
*NumberOfTimesExerciseIsDone is what you normally understand as repetitions.
*But in this context repetion is what is set with setNumberOfTimesExerciseIsRepeatedInARotation()
* @post getNumberOfTimesExerciseIsDone(int rotation, int repetition) == number
*@param rotations start counting from 0
*@param repetition start counting from 0
* @returns 
* | true when succesfull
* | false when rotation or repetition for that rotation doesn't exist.
* | false when number is smaller then 1.
*/
bool TrainingSchedule::setNumberOfTimesExerciseIsDone(int rotation, int repetition, int number){
if(number<1){return false;}
else if(rotation >= numberOfTimesExerciseIsDoneList->size()){return false;}
else if(repetition >= numberOfTimesExerciseIsDoneList->at(rotation)->size()){return false;}
else{
QList<int> *list = numberOfTimesExerciseIsDoneList->at(rotation);
list->replace(repetition,number);
return true;
}
return true;
}

/**
*This method increases the number of rotations with 1.
*The new rotation has one repetition/iteration and the repetitions performance is DEFAULT_PERFORMANCE and
*the repetitions numerOfTimesExerciseIsDone is DEFAULT_NUMBEROFTIMESEXERCISEISDONE
*@return
* | index/number of the new rotation.
*/
int TrainingSchedule::addRotation(){
QList<int> *newlist1 = new QList<int>();
newlist1->append(DEFAULT_PERFORMANCE);
performanceList->append(newlist1);

QList<int> *newlist2 = new QList<int>();
newlist2->append(DEFAULT_NUMBEROFTIMESEXERCISEISDONE);
numberOfTimesExerciseIsDoneList->append(newlist2);

return performanceList->size()-1;
}

/**
*This method adds a repetition to rotation 'rotation'.
*The new repetitionss performance is DEFAULT_PERFORMANCE and
*the repetitions numerOfTimesExerciseIsDone is DEFAULT_NUMBEROFTIMESEXERCISEISDONE
* @return
* | index/number of the new repetition.
*/
int TrainingSchedule::addRepetition(int rotation){
QList<int> *templist1 = performanceList->at(rotation);
templist1->append(DEFAULT_PERFORMANCE);

QList<int> *templist2 = numberOfTimesExerciseIsDoneList->at(rotation);
templist2->append(DEFAULT_NUMBEROFTIMESEXERCISEISDONE);

return performanceList->at(rotation)->size()-1;
}

/**
*@return Returns the name of the Schedule
*/
QString TrainingSchedule::getName(){
return this->name;
}

/**
*@return Returns the explanation of this schedule
*/
QString TrainingSchedule::getExplaination(){
return this->explaination;
}

/**
*@return Returns the number of rotations of this schedule
*/
int TrainingSchedule::getNumberOfRotations(){
return this->performanceList->size();
}

/**
*@see the setter
*\note make sure rotation and repetition are inbound. Out of range=> crash :-)
*/
int TrainingSchedule::getNumberOfTimesExerciseIsDone(int rotation, int repetition){
QList<int> *list = numberOfTimesExerciseIsDoneList->at(rotation);
return list->at(repetition);
}

/**
*@return number of iterations for the given Rotation.
*\note make sure rotation is inbound. Out of range=> crash :-)
*/
int TrainingSchedule::getNumberOfTimesExerciseIsRepeatedInARotation(int rotation){
return numberOfTimesExerciseIsDoneList->at(rotation)->size();
}

/**
*@see the setter
*@return performace of given rotation and repetition
*\note make sure rotation and repetition are inbound. Out of range=> crash :-)
*/
int TrainingSchedule::getPerformance(int rotation,int repetition){
QList<int> *list = performanceList->at(rotation);
return list->at(repetition);
}

/**
*@return string version of the schedule, so it can be saved in a text-file.
*/
QString TrainingSchedule::toString(){
QString result=getName();
result.append("!");
result.append(getExplaination());
result.append("!");
for(int rot=0;rot<getNumberOfRotations();rot++){
	for(int iter=0;iter<getNumberOfTimesExerciseIsRepeatedInARotation(rot);iter++){
	QString temp="Rotation_";
	QString num; num.setNum(rot);  temp.append(num);
	temp.append("_Iteration_");
	num.setNum(iter);  temp.append(num);
	temp.append("_Performance_");
	num.setNum(getPerformance(rot,iter));  temp.append(num);
	temp.append("_Repetitions_");
	num.setNum(getNumberOfTimesExerciseIsDone(rot,iter));  temp.append(num);
	temp.append("_!");
	result.append(temp);
	}
}
return result;
}