//
// C++ Interface: Training
//
// Description: 
//
//
// Author: Muylkens Toon <toon.muylkens@student.kuleuven.be>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
/**
 * \class TrainingSchedule
 *
 * \brief Provide an example
 *
 * This class is a training-schedule. It is a method of training.
 * It tells the user how many times to do an exercise and with which weight
 *
 * \note The name can never be changed
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */
#ifndef TRAININGSCHEDULE_H
#define TRAININGSCHEDULE_H
#include <QtCore/QList>
#include <QtCore/QString>
#include <QTextStream>


class TrainingSchedule
 {
public:
// 	static const int DEFAULT_PERFORMANCE=100;
// 	static const int DEFAULT_NUMBEROFTIMESEXERCISEISDONE=10;

     	TrainingSchedule(QString name="Name", QString explaination="Explanation");
	~TrainingSchedule(){}

	QString toString();
	
	void setExplaination(QString newExplaination);
	void setName(QString newName);
	void setNumberOfRotations(int i);
	bool setPerformance(int rotation, int repetition, int performance);
	bool setNumberOfTimesExerciseIsDone(int rotation, int repetition, int number);

	QString getName();
	QString getExplaination();
	int getNumberOfRotations();
	int getNumberOfTimesExerciseIsRepeatedInARotation(int rotation); ///alias number of iterations
	int getPerformance(int rotation, int repetition);
	int getNumberOfTimesExerciseIsDone(int rotation, int repetition);

	int addRotation();
	int addRepetition(int rotation);
private:
	QString name;
	QString explaination;
	int numberOfRotations;
	int numberOfTimesExerciseIsRepeatedInARotation;
	QList< QList<int>* > *performanceList;
	QList< QList<int>* > *numberOfTimesExerciseIsDoneList; ///for every rotation a list of values for the iterations
 };

const int DEFAULT_PERFORMANCE=100;
const int DEFAULT_NUMBEROFTIMESEXERCISEISDONE=10;

#endif //TRAININGSCHEDULE_H
