/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "ViewAndManageExercise.h"


// #include <QtSql/QSqlDatabase>
//  #include <stdio.h>
//   #include <iostream>
//   using namespace std;

ViewAndManageExercise::ViewAndManageExercise(QWidget *parent,ConfigFileHandlerPowerTraining *filehandler)
     : QWidget(parent)
 {
     //	ui.setupUi(this);
	this->filehandler = filehandler;
		
	exerciseWidgetList = new QList<OneExercise*>();

 	buildGui();


}

/**
*Builds the gui elements, (scrollwidget, tabbs, ...)
*/
void ViewAndManageExercise::buildGui(){
	///TAB 1
 	QVBoxLayout *layout1 = new QVBoxLayout(this);
	this->setLayout(layout1);
 	QScrollArea *scrollareaexercises= new QScrollArea(this);
	layout1->addWidget(scrollareaexercises);
	scrollareaexercises->show();
	scrollareaexercises->setFrameShape(QFrame::NoFrame);
	scrollareaexercises->setFrameShadow(QFrame::Plain);
	container = new QWidget(scrollareaexercises);
     	gridLayout = new QGridLayout(container);
	container->setLayout(gridLayout);
     	container->show();
	scrollareaexercises->setWidget(container);
	
	///TAB 2
// 	QVBoxLayout *layout2 = new QVBoxLayout;
// 	layout2->setMargin(0);
//       	ui.tab2->setLayout(layout2);
//  	secondTab = new AddExerciseDialog(this,filehandler);
//  	QObject::connect(secondTab,SIGNAL(exerciseAdded()),this,SLOT(exerciseWasAdded()));
//  	layout2->addWidget(secondTab);
//  	secondTab->show();
// 
// 	QObject::connect(secondTab,SIGNAL(exerciseTagListChanged()),this,SLOT(reloadAllTagLists()));
	
}

/**
 * convenient function. This function is executed fe when a new profile is openend. same as drawWidgets()
 */
void ViewAndManageExercise::loadsettings(ConfigFileHandlerPowerTraining *filehandler)
{
this->filehandler=filehandler;
drawWidgets();
//secondTab->loadsettings(filehandler);
}

/**
 * this method add one OneExercise widget for every exercise in the filehandler/exercise class
 */
void ViewAndManageExercise::drawWidgets()
{
removeWidgets();
/*this->setMinimumHeight(300);
this->resize(this->width(),300)*/;
int row=0; 
int collumn=0;
exerciseWidgetList->clear();
	for(int i=0; i< filehandler->getExercise()->getNbOfExercises(); i++)
	{
	int index = filehandler->getExercise()->getIndexes().at(i);
	Exercise *ex = filehandler->getExercise()->getExercise(index);
	exerciseWidgetList->insert(i, new OneExercise(container, i,filehandler->getExercise()->getPossibleMuscleList(),filehandler->getExercise()->getPossibleExerciseTagList()));
	exerciseWidgetList->at(i)->setTitle(ex->getName());
	exerciseWidgetList->at(i)->setExerciseExplaination(ex->getExplanation());
	exerciseWidgetList->at(i)->setExerciseName(ex->getName());
	exerciseWidgetList->at(i)->setTag(ex->getTag());
	exerciseWidgetList->at(i)->addMuscles(ex->getMuscleList());
	exerciseWidgetList->at(i)->show();
	exerciseWidgetList->at(i)->setAutoSaveFunctionOn();
	QObject::connect(exerciseWidgetList->at(i),SIGNAL(saveExercise(QString,QString,QStringList,QString,int)), this, SLOT(saveExercise(QString, QString,QStringList,QString,int)));
	QObject::connect(exerciseWidgetList->at(i),SIGNAL(deleteExercise(int)), this, SLOT(deleteExercise(int)));
	QObject::connect(exerciseWidgetList->at(i),SIGNAL(addTag(QString)), this, SLOT(addTag(QString)));
	gridLayout->addWidget(exerciseWidgetList->at(i), row, collumn);
	collumn++;
	if(collumn==2){collumn=0;row++;}
	}
	gridLayout->addItem(new QSpacerItem(10,10, QSizePolicy::Minimum, QSizePolicy::Expanding), row+1, 0);
row++; ///because we started counting from 0
container->setMinimumHeight(row*440);
}

/**
*adds an exercisetag to the QProfile
*/
void ViewAndManageExercise::addTag(QString tag){
filehandler->getExercise()->addExerciseTag(tag);
reloadAllTagLists();
}

/**
*Reload the list of tags to choose from for every gui compontent representing an exercise
*/
void ViewAndManageExercise::reloadAllTagLists(){
for(int i=0; i< filehandler->getExercise()->getNbOfExercises(); i++)
	{
	exerciseWidgetList->at(i)->reloadTagList(filehandler->getExercise()->getPossibleExerciseTagList());
	}

}

/**
 * remove/close all the OneExerciseWidgets
 */
void ViewAndManageExercise::removeWidgets()
{
for(int i=0; i<exerciseWidgetList->size();i++)
{
exerciseWidgetList->at(i)->close();
}
exerciseWidgetList->clear();
container->setMinimumHeight(100);
container->setMaximumHeight(100);
}

/**
 * set the width, necessery because of the QScrollArea, slot
 */
void ViewAndManageExercise::rescale()
{
container->resize(parentWidget()->size().width()-40,this->height());
//container->setMinimumWidth(300);
}

/**
*Saves all exercises on disk
*/
void ViewAndManageExercise::saveAll(){
for(int i=0; i<exerciseWidgetList->size();i++){
	exerciseWidgetList->at(i)->save();
	}
}



/**
 * slot: an exercise was added, we add it to the list
 */
void ViewAndManageExercise::exerciseWasAdded()
{
emit redrawNeeded();
drawWidgets();
}

/**
 * exercise will be renamed and explaination will also be saved
 * @param newname 
 * @param newexplaination 
 * @param index 
 */
void ViewAndManageExercise::saveExercise(QString newname, QString newexplaination,QStringList newMuscleList,QString newtag,int index)
{
filehandler->saveExercise(newname, newexplaination, newMuscleList, newtag,index);
emit redrawNeeded();
}


/**
 * delete an exercise with nr index
 * @param index 
 */
void ViewAndManageExercise::deleteExercise(int index)
{
	QMessageBox msgBox;
	msgBox.setStandardButtons(QMessageBox::Yes|QMessageBox::No);
	msgBox.setText(tr("Are you sure you want to delete the exercise?\nAll the entered datapoints will also be deleted."));
	switch (msgBox.exec()) 
		{
		case QMessageBox::Yes:
		filehandler->deleteExercise(index);
		emit redrawNeeded();
		drawWidgets();
		break;
		default:
		// should never be reached
		break;
		}
rescale();

}
