/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/**
 * \class ViewAndManageExercise
 *
 * \brief Provide an example
 *
 * This class is a QWidget. It lets the user modify exercises and can call the
 * addExercise dialog
 *
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */

#ifndef VIEWANDMANAGEEXERCISE_H
#define VIEWANDMANAGEEXERCISE_H



// #include "ui_ViewAndManageExercise.h"
#include "ConfigFileHandlerPowerTraining.h"
#include "ExerciseHandler.h"
#include "OneExercise.h"
#include "AddExerciseDialog.h"
#include <QApplication>
#include <QtGui/QWidget>
#include <QtGui/QMessageBox>
#include <QtCore/QList>
#include <QtGui/QLabel>
#include <QtGui/QScrollArea>

class ViewAndManageExercise : public QWidget
 {
     Q_OBJECT

 public:
     	ViewAndManageExercise(QWidget *parent = 0,ConfigFileHandlerPowerTraining *filehandler=0);

	void loadsettings(ConfigFileHandlerPowerTraining *filehandler);
 private:
     	//Ui::ViewAndManageExercise ui;
	ConfigFileHandlerPowerTraining *filehandler;
	QList<OneExercise*> *exerciseWidgetList;

	QWidget *container;
	QGridLayout *gridLayout;
	
	//AddExerciseDialog *secondTab;

	void removeWidgets();
	void buildGui();
private slots:
	void exerciseWasAdded();
	void addTag(QString tag);
public slots:
	void saveAll();
	void drawWidgets();
	void rescale();
	void saveExercise(QString newname, QString newexplaination,QStringList newMuscleList,QString newtag, int index);	
	void deleteExercise(int index);
	void reloadAllTagLists();
signals:
	void redrawNeeded();///fe exerciseAdded(), exerciseRenamed() ExerciseDeleted();
};


#endif // VIEWANDMANAGEEXERCISE_H
