/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/**
 * \class ViewAndManageSchedule
 *
 * \brief 
 *
 * This class is a QWidget. It shows the schedules
 * allows to edit then, print temp, delete them
 *
 * \note In the future maybe XML will be used, for now we use HTML for the programs
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */
#ifndef VIEWANDMANAGESCHEDULE_H
#define VIEWANDMANAGESCHEDULE_H

 #include <QMessageBox>
#include "ui_ViewAndManageSchedule.h"
#include "ui_OneSchedule.h"
#include "ui_TrainingScheduleDesigner.h"
#include "ConfigFileHandlerPowerTraining.h"
#include "TrainScheduleDisplayer.h"
#include "TrainingSchedule.h"
#include "SelectExerciseWidget.h"
#include "StringCheck.h"
#include <QApplication>
#include <QtGui/QWidget>
#include <QtCore/QSettings>


class OneSchedule;

class ViewAndManageSchedule : public QWidget
 {
     Q_OBJECT

 public:
     	ViewAndManageSchedule(QWidget *parent = 0, ConfigFileHandlerPowerTraining *filehandler=0);
	
	void loadsettings(ConfigFileHandlerPowerTraining *filehandler);
 private:
     	Ui::ViewAndManageSchedule ui; ///TrainPrograms is the old name for ViewAndManageSchedule.
	ConfigFileHandlerPowerTraining *filehandler;
	QList<OneSchedule *> oneScheduleList;
	TrainScheduleDisplayer *displayer;
	SelectExerciseWidget *selectExerciseWidget;

private slots:
	void editSchedule(QString name);
	void deleteSchedule(QString name,OneSchedule *widget);	
	void someTrainingScheduleChanged(QString oldName, TrainingSchedule *newschedule);
public slots:
	void showSchedule(QList<QString> allowedExercisesList, QString name);
	void showSchedule(QString name);
	void addSchedule();
	void reloadScheduleList();
	void rescale();
signals:
	void reloadScheduleNames();
 };


class OneSchedule:public QWidget
{
     Q_OBJECT

 public:
     	OneSchedule(QWidget *parent = 0);
	void setExplanation(QString newexp);
	void setName(QString newname);
 private:
     	Ui::OneSchedule ui; ///TrainPrograms is the old name for ViewAndManageSchedule.
	
private slots:
	void showSchedule();
	void editSchedule();
	void deleteSchedule();
signals:
	void showSchedule(QString name);
	void deleteSchedule(QString name, OneSchedule *thisObject);
	void editSchedule(QString name);
};


class TrainingScheduleDesigner:public QWidget
{
     Q_OBJECT

 public:
     	TrainingScheduleDesigner(QWidget *parent = 0,ConfigFileHandlerPowerTraining *filehandler=0 );
	TrainingSchedule getTrainingSchedule();
	void setSchedule(TrainingSchedule *schedule);
 private:
     	Ui::TrainingScheduleDesigner ui; ///TrainPrograms is the old name for ViewAndManageSchedule.
	TrainingSchedule *schedule;
	QString getExplanation();
	QString getName();
	ConfigFileHandlerPowerTraining *filehandler;

	QString oldName; ///when in editMode, contains the name before the edit.
	bool editMode; ///editing an existing schedule or not
private slots:
	void addRotation();
	void addIteration();
	void currentSelectedRotationChanged(int currentRow);
	void currentSelectedIterationChanged(int currentIteration);
	void performanceChanged(int newvalue);
	void repetitionsChanged(int newvalue);
	void returnSchedule();
signals:
	void reloadScheduleList(); ///when a Schedule is added or changed, reload the schedule list!
	void changed(QString oldname, TrainingSchedule *newschedule); ///always emitten pressing save and in editMode
};
#endif //VIEWANDMANAGESCHEDULE_H

