/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
/**
 * \class Plotter
 *
 * \brief Provide an example
 *
 * This class is a QPushButton. The only extension is the signal pressedQtrainer
 * which sends an integer with it, the integer is the 'number' of the button corresponding
 * with the exercise numbers
 *
 * \note Nothing to note
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */


#ifndef QTRAINERBUTTON_H
#define QTRAINERBUTTON_H

#include <QtGui/QPushButton>


class QtrainerButton : public QPushButton
 {
     Q_OBJECT

 	public:
	QtrainerButton(QWidget *parent=0);
	void setindex(int index);
//	void setText(QString text);
	private:
	int index;
	private slots: 
	void send();
	signals:
	void pressedQtrainer(int i);
	
}; 	

#endif
