//
// C++ Implementation: Training
//
// Description: 
//
//
// Author: Muylkens Toon <toon.muylkens@student.kuleuven.be>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "QtrainerMeasurable.h"
// #include <stdio.h>
// #include <iostream>
// using namespace std;

/**
*constructs a new QtrainerMeasurable
*/
QtrainerMeasurable::QtrainerMeasurable(int index, QObject *parent):QObject(parent)
 {
	this->index=index;
 }

/**
*constructs a new QtrainerMeasurable
*/
QtrainerMeasurable::QtrainerMeasurable(int index, QString name, QString explanation, int nbPointsToPlot, QStringList plotMethodList ,QObject *parent):QObject(parent){
this->index=index;
this->object=name;
this->explanation = explanation;
this->plotMethodList = plotMethodList;
this->nbPointsToPlot  = nbPointsToPlot;
}

QStringList QtrainerMeasurable::getPlotMethod(){
return this->plotMethodList;
}

/**
*Returns true if one of the plotmethods is bezier
*/
bool QtrainerMeasurable::getBezier(){
return this->plotMethodList.contains("Bevier");
}

/**
*Returns true if one of the plotmethods is line
*/
bool QtrainerMeasurable::getLine(){
return this->plotMethodList.contains("Line");
}

/**
*Returns true if one of the plotmethods is spline
*/
bool QtrainerMeasurable::getSpline(){
return this->plotMethodList.contains("Spline");
}

/**
*Sets the number of points that are plotted to number
*/
void QtrainerMeasurable::setNbOfPointsToPlot(int number){
nbPointsToPlot = number;
emit measurementChanged();
}

/**
*returns the number of points that are plotted or need to be plotted
*/
int QtrainerMeasurable::getNbOfPointsToPlot(){
return this->nbPointsToPlot;
}

/**
*which method to use for plotting: Bevier (idd it should be bezier), line and spline
*/
void QtrainerMeasurable::setPlotMethod(QStringList plotMethodList){
this->plotMethodList = plotMethodList;
emit measurementChanged();
}



QString QtrainerMeasurable::getName() const{
return this->object;
}


QString QtrainerMeasurable::getExplanation(){
return explanation;
}

void QtrainerMeasurable::setExplanation(QString explanation){
this->explanation=explanation;
emit measurementChanged();
}

void QtrainerMeasurable::setName(QString name){
this->object=name;
emit measurementChanged();
}

/**
*Needs reimplemantation!
*
*returns the value on the given date
*/
int QtrainerMeasurable::getValue(StringDate date){

}

/**
*Returns a QVector with the first points the most recent one. 
*The other points are ordered by the day they where entered.
*X-coordinate is the number of days ago the data was entered.
*Y-coordinate is the corresponding value
*
*Needs reimplemantation!
*/
QVector<QPointF> QtrainerMeasurable::getVector(){
return QVector<QPointF>();
}

/**
*Returns the unique ID that index is
*/
int QtrainerMeasurable::getIndex(){
return index;
}