/**
 * \class QtrainerMeasurable
 *
 * \brief Provide an example
 *
 * A Measurable is something that can be measured. It can be be visualised by plotting, ...
 *
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */
#ifndef QTRAINERMEASURABLE_H
#define QTRAINERMEASURABLE_H
#include <QTime>
#include <QDate>
#include <QObject>
#include "QStringDates.h"
#include <QTextStream>
#include <QPointF>
#include <QVector>
#include <QWidget>
#include <QObject>

class QtrainerMeasurable : public QObject
 {
	Q_OBJECT
protected:
	int nbPointsToPlot;
	QStringList plotMethodList;
	QString object;
	QString explanation;
	int index;
public:
     	QtrainerMeasurable(int index, QString name, QString explanation, int nbPointsToPlot, QStringList plotMethodList ,QObject *parent=0);
	QtrainerMeasurable(int index, QObject *parent=0);
	QString getName() const;
	QString getExplanation();
 	void setExplanation(QString explanation);
 	void setName(QString name);

	int getValue(StringDate date);
	QVector<QPointF> getVector();
	
	bool getLine();
	bool getSpline();
	bool getBezier();
	void setPlotMethod(QStringList plotMethodList); //which method to use for plotting
	QStringList getPlotMethod();
	void setNbOfPointsToPlot(int nb);
	int getNbOfPointsToPlot();

	int getIndex();

signals:
	void measurementChanged(); ///something changed to the measurement

 };

#endif //QTRAINERMEASURABLE_H
