/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/**
 * \class QtrainerPlotFrame
 *
 * \brief Provide an example
 *
 * This class is a Qwidget, containing a Plotter and soms controlls for the plotter
 * How to use?
 * Provide this widget with a DataVector and tell it how many of those points need to be plotted 
 * as well as how they should be visualised.
 *
 * \note Nothing to note
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */

#ifndef QTRAINERPLOTFRAME_H
#define QTRAINERPLOTFRAME_H

#include "ui_QtrainerPlotFrame.h"
#include <QtGui/QWidget>
#include <QtGui/QLabel>
#include <QtCore/QString>
#include "plotter.h"

class Extremes; ///preloading, class Extremes will return me min and max values.

class QtrainerPlotFrame : public QWidget
 {
     Q_OBJECT

 public:
     	QtrainerPlotFrame(QWidget *parent = 0, int myindex=0);
	void setTitle(QString title);
	void setDataAndPlot(QVector<QPointF> vector); //vector should always be full size. see setnbpointstoplot()
	void replot();
	void setPlotMethod(bool bezier, bool line, bool spline); //tells Plotter what to plot.
	bool setNbOfPointsToPlot(int number); //only plot the 'number' last datapoints
	int getNbOfPointsPlotted(); // returns how many points are used for the current plot
	int getMyIndex();
	void setNumberOfPointsToPlot(int i); //initialize the number of points to plot or override the selected value by the user.
	QString getTitle();
 private:
     	Ui::QtrainerPlotFrame ui;

	Plotter* getPlotter();
	QVector<QPointF> getData(); //all the data
	QVector<QPointF> getTruncatedData(); //only the most recent getNbOfPointsPlotted()

	void setSliderMaximum(int i);
	void plotMethodChanged();
	void setCheckBoxes();
	void calculateTruncatedData();

	int myindex;
	Plotter *myPlotter;
	QVector<QPointF> plotData; //data vector
	QVector<QPointF> truncatedData; //data vector, only the getNbOfPointsPlotted() most recent points.

	bool bezier; //true when plotting bezier curves
	bool line; //true when plotting lines
	bool spline; //true when plotting splines
	
private slots:
	void sliderValueChanged(int i); //the user requested more or less points to be plotted
	void setPlotMethod(int state); //signal triggered by checkboxes
	
signals:
	void nbOfPointsPlottedChanged(int i, int index);
	void plotMethodChanged(QStringList methodlist, int index);
 };

class Extremes
{
public: 
	Extremes(QVector<QPointF> vector);
	double getminy();
	double getmaxy();
private:
	QVector<QPointF> vector;
};

#endif //QTRAINERPLOTFRAME_H
