/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
/**
 * \class QtrainerPlotWidget
 *
 * \brief 
 *
 * The universal PlotWidget, which contains a number of frames, each plotting some data
 * Uploading of the visualised data is also possible
 *
 * Provide this widget with N datasets and it will contain N QtrainerPlotWidgets 
 * each visualizing one dataset.
 * \note
 * The widget will grow as big as it neads to... So put it into a QSrollArea
 *
 * \author Toon Muylkens
 *
 * \date 2008/01/02
 *
 * Contact: toon.muylkens@student.kuleuven.be
*/

#ifndef QTRAINERPLOTWIDGET_H
#define QTRAINERPLOTWIDGET_H


//#include <QScrollArea>
#include "QtrainerPlotFrame.h"

#include "ui_QtrainerPlotWidget.h"
#include <QtGui/QWidget>
#include <QtCore/QVectorIterator>
#include <QtCore/QSettings>
#include <QtCore/QList> 
#include "qxtxmlrpcclient.h"
#include <QtCore/QVariant>
#include <QtGui/QMessageBox>
#include <QtCore/QSettings>
#include "LoginRegisterWidget.h"

class QtrainerPlotWidget : public QWidget
 {
     Q_OBJECT

 public:
     	QtrainerPlotWidget(QWidget *parent = 0);
	void addDataSet(QVector<QPointF> vector, int numberOfPointsToPlot=-1, QString title="",  bool bezier =true, bool line = false, bool spline = false); //add a set of points needed to be visualised
	void addDataSets(QList< QVector<QPointF> > vectorlist); //add a list of sets of points needed to be visualised TODO not yet implemented
	void updateDataSet(QVector<QPointF> newvector,int numberOfPointsToPlot, QString title, int index);

	void setText(QString text); //Set the welcomes/information text
	void clear(); //remove all QtrainerQtrainerPlotFrames

	int getNbOfPlotFrames();
 private:
     	Ui::QtrainerPlotWidget ui;
	
	QList<QtrainerPlotFrame*> *plotlist; //list of QtrainerPlotFrames each containing one plotter

	QtrainerPlotFrame* returnPlotFrame(QVector<QPointF> vector, int number, QString title,bool bezier, bool line, bool spline);
	int getRowInGrid(int index);//returns row number of the widget with index index
	int getColumnInGrid(int index); //returns columns number
	void setupconnectionsanddefaults();

	void uploadSendXML(int numberofexercise,QString username, QString passwd); ///does the real uploading
	void removeOldPlotsSendXML(QString username, QString passwd); ///removes old plots from the server

private slots:
	//void valuechanged(int shownumberofpoints, int index);
	//void reload();

	void fault(int callId, int faultCode, QString faultString);
	void parseError(int callId, QString errorMsg);
	void networkError(int callId, QString errorMsg);
	void finished(int callId, QVariant retValue);

	void uploadPlots(QString username,QString passwd);
	void saveNbOfPlointsToPlot(int newnumber,int index);
	void savePlotMethod(QStringList methodlist, int);
	
public slots:
	void upload();
	void rescale();
	

signals:
	void succesFullUpload();
	void unsuccesFullUpload();

	void saveNbOfPointsToPlotInProfile(int newnumber, int index);
	void savePlotMethodInProfile(QStringList methodlist, int index);
};


#endif // PLOTWIDGET_H
