/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "QtrainerWelcomsWidget.h"
//   #include <stdio.h>
//  #include <iostream>
//  using namespace std;


QtrainerWelcomsWidget::QtrainerWelcomsWidget(QWidget *parent)
     : QWidget(parent)
 {
	ui.setupUi(this);
	svgRenderer =  new QSvgRenderer(ui.logoWidget);
	svgRenderer->load(QString(":/logos/logo.svg"));
	
	///load profiles in lost
	populatelist();
	///connections
	QObject::connect(ui.okbutton,SIGNAL(pressed()),this, SLOT(loadprofile()));
	QObject::connect(ui.listWidget,SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(itemClicked(QListWidgetItem*)));
	QObject::connect(ui.newbutton,SIGNAL(pressed()),this, SLOT(newprofile()));
	something_selected=false;
}


void QtrainerWelcomsWidget::loadprofile()
{
	if(something_selected){
	QString profilename = (ui.listWidget->currentItem())->text();
	emit signalfinished(profilename);
	this->close();
	}
}

/**
*Opens the newprofile wizard
*/
void QtrainerWelcomsWidget::newprofile()
{
	emit newProfile();
}

void QtrainerWelcomsWidget::populatelist()
{
	ui.listWidget->clear();

	///read the necessarry settings
	QSettings settings("ToonSoft", "Qtrainer");
	settings.beginGroup("ProgramSettings");
	QString allprofiles=(settings.value("Profiles")).toString();
     	settings.endGroup();

	///append them all to the list.
	int i=1;
	while((allprofiles.section('!',i,i)).size()>0)
	{
		QString label = allprofiles.section('!', i, i);
// 		ConfigFileHandler *filehandler = new ConfigFileHandler(label);
// 		label.append(" - ");
// 		label.append(filehandler->getSport());
		QListWidgetItem *SettingsItem = new QListWidgetItem(label,ui.listWidget);
		i++;
	}
}

void QtrainerWelcomsWidget::itemClicked(QListWidgetItem* item){
this->something_selected=true;
}


void QtrainerWelcomsWidget::paintEvent(QPaintEvent *)
 {
	QPainter p(this);
        //p.setViewport(0, 0, width(), height());
	svgRenderer->render(&p, QRectF(ui.logoWidget->rect()));
 }


