/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
/**
 * \class QtrainerWelcomsWidget
 *
 * \brief Provide an example
 *
 * This class is a QWidget. It displayes information, lets the user select a profile or create a new one.
 *
 * \note Nothing to note
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */

#ifndef QTRAINERWELCOMSWIDGET_H
#define QTRAINERWELCOMSWIDGET_H

#include "ui_QtrainerWelcomsWidget.h"
#include <QtSvg/QSvgRenderer>
#include <QPainter>

#include <QtCore/QString>
#include <QtGui/QListWidgetItem>
#include <QtGui/QWidget>
#include <QSettings>

// #include "ConfigFileHandler.h"


class QtrainerWelcomsWidget : public QWidget
 {
     Q_OBJECT

 public:
    	QtrainerWelcomsWidget(QWidget *parent = 0);
 private:
	Ui::QtrainerWelcomsWidget ui;
	QSvgRenderer *svgRenderer;
	void paintEvent(QPaintEvent *);
	
	bool something_selected;
	
private slots:
	void loadprofile();
	void itemClicked(QListWidgetItem* item);
	void newprofile();
public slots:
	void populatelist();
signals:
	void signalfinished(QString profilename);
	void newProfile();
};
#endif
	