/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
/**
 * 
 * \brief Provide an example
 *
 * Qtainer is a QT-program
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */

#include <QApplication>
#include "MainWindow.h"
#include <stdio.h>
#include <iostream>
using namespace std;



///this is the main method
int main(int argc, char *argv[])
{
	//Q_INIT_RESOURCE(application);
      	QApplication app(argc, argv);
	
	///user entered --help as an argument
	if(app.arguments().size()>1 && app.arguments().at(1)=="--help"){
	cout<<"USAGE:"<<endl;
	cout<<"'qtrainer --help' for this"<<endl;
	cout<<"'qtrainer PROFILENAME' for opening a profile in the Qtrainer profile path"<<endl;
	cout<<"'qtrainer' for opening Qtrainer"<<endl;
	app.quit();
	}
	else{
   		MainWindow *mainWin = 0;
   		mainWin = new MainWindow();

		if(app.arguments().size()>1){
		///a profile was given as argument
		bool succes = mainWin->openproject(app.arguments().at(1));
		if(succes) {cout<<"The profile was succesfully loaded"<<endl;}
		if(!succes) {cout<<"Qtrainer couldn't find the profile in your profile path or The given profile is of an unknown type/sport"<<endl;
		cout<<"To start Qtrainer with a given profile: qtrainer PROFILENAME"<<endl;
		cout<<"Just the profilename, not the path to the profilename"<<endl;
		cout<<"You can change the profile path in qtrainer->Preferences"<<endl;
		}
		}
   	mainWin->show();
	return app.exec();
	}
}

