/***************************************************************************
 *   Copyright (C) 2007 by Muylkens Toon   *
 *   toon.muylkens@student.kuleuven.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
/**
 * \class Plotter
 *
 * \brief Provide an example
 *
 * Plotter is a class that uses QPainter to make graphs
 *
 * \note Nothing to note
 *
 * \author Toon Muylkens
 *
 * \date 2007/02/13
 *
 * Contact: toon.muylkens@student.kuleuven.be
 *
 */




#ifndef PLOTTER_H
#define PLOTTER_H


#include <QtCore/QMap>
#include <QtGui/QPixmap>
#include <QtCore/QVector>
#include <QtGui/QWidget>

#include "qwt_spline.h"


class QToolButton;
class PlotSettings;

class Plotter : public QWidget
{
    Q_OBJECT

public:
    Plotter(QWidget *parent = 0);

    /**
    Number of interpolation points generated by the spline engine
    */
    static const int NB_SPLINES_INTERPOLATION_POINTS = 100;

    void setPlotSettings(const PlotSettings &settings);
    void setCurveData(int id, const QVector<QPointF> &data, bool erease=false);
    void clearCurve(int id);
    QSize minimumSizeHint() const;
    QSize sizeHint() const;
	void adjustAxis(double &minx, double &maxx,double &miny, double &maxy );

public slots:
    void zoomIn();
    void zoomOut();

protected:
    void paintEvent(QPaintEvent *event);
    void resizeEvent(QResizeEvent *event);
//     void mousePressEvent(QMouseEvent *event);
//     void mouseMoveEvent(QMouseEvent *event);
//     void mouseReleaseEvent(QMouseEvent *event);
//     void keyPressEvent(QKeyEvent *event);
//     void wheelEvent(QWheelEvent *event);

private:
    void updateRubberBandRegion();
    void refreshPixmap();
    void drawGrid(QPainter *painter);
    void drawCurves(QPainter *painter);
	
// 	PlotSettings *settings;

    enum { Margin = 30 };

//     QToolButton *zoomInButton;
//     QToolButton *zoomOutButton;
    QMap<int, QVector<QPointF> > curveMap;
    QVector<PlotSettings> zoomStack;
    int curZoom;
    bool rubberBandIsShown;
    QRect rubberBandRect;
    QPixmap pixmap;
 };

 class PlotSettings
{
public:
    PlotSettings();

    void scroll(int dx, int dy);
    void adjust();
    double spanX() const { return maxX - minX; }
    double spanY() const { return maxY - minY; }

    double minX;
    double maxX;
    int numXTicks;
    double minY;
    double maxY;
    int numYTicks;
private:
    static void adjustAxis(double &min, double &max, int &numTicks);
};

#endif
