/***************************************************************************
 *            remosync.h
 *
 *  Fri Oct 24 11:25:40 2003
 *  Copyright  2003  Phil Kett
 *  pkett@genesis-midi.com
 ****************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef REMSYNCH
#define REMSYNCH 1
#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif

#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/stat.h>
#include <dirent.h>
#include <utime.h>

#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif
#ifdef HAVE_SIGNAL_H
#include <signal.h>
#endif

#include <string.h>
#include <sys/stat.h>
#include <fcntl.h>
//#include <netinet/in.h>
//#include <inttypes.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/wait.h>
#include <syslog.h>
#include <errno.h>
#include <time.h>

#include "../include/remsync_crc.h"

#define BIG_BUF 8192 /* Length of strings */
#define ARRAY_MAX_ELEM 10 /* Maximum number of elements in array */
#define VERSTR "Remosync Version "VERSION
#define DEFAULT_CONF "/etc/remosync.cf"
#define DEFAULT_PORT 9097
#define DEFAULT_PIDFILE "/tmp/remosync.pid"

struct config {
	char source[BIG_BUF]; /* Source directory */
	char dest[BIG_BUF]; /* destination directory */
	char host[BIG_BUF]; /* hostname to connect to */
	char ip_list[BIG_BUF];	/* comma seperated list of allowed IP addresses */
	char config_file[BIG_BUF]; /* config file supplied on command line */
	char pidfile[BIG_BUF]; /* location of pid file */
	char debuglog[BIG_BUF]; /* path of debug logfile (optional) */
	char notify[BIG_BUF];
	#ifdef HAVE_FNOTIFY
	int monitor; /* yes or no */
	#endif
	int port; /* Port to connect or run server */
	int server; /* yes or no */
	int remote; /* yes or no */
	int restart; /* flag set by sighup handler to indicate restart required */
	int debug; /* Running in debug mode? */
	int deletes; /* flag, do we do client deletes */
	int stats; /* whether we're collecting stats */
	int newer; /* Whether we're checking for newer files on the destination */
	int timestamp; /* Whether we're preserving timestamps */
};
struct statistics {
	time_t start; /* time started */
	time_t finish; /* time finished */
	double transfer_time; /* time spent transferring files */
	unsigned long int num_files_processed;
	unsigned long int num_files_copied;
	unsigned long int num_dirs_processed;
	unsigned long int num_dirs_copied;
	unsigned long int num_links_processed;
	unsigned long int num_links_copied;
	unsigned long int num_files_deleted;
	unsigned long long int total_bytes_copied;
	
};


extern struct config conf;
extern struct statistics stats;
	

/* Structure for string splits */

struct split {
    char text[BIG_BUF];
    int length;
};

/* Structure for storing stat values as strings */
struct strstat { 
	char filename[BIG_BUF];
	char owner[BIG_BUF]; 
	char group[BIG_BUF];
	char mode[BIG_BUF]; 
	char mod_time[BIG_BUF]; 
	char acc_time[BIG_BUF];
};



void usage ();
int  is_a_dir(char *filename);
int copy_file(char *src, char *dest);
int size_check(char *file1, char *file2);
int start_server(int port);
int file_exists(char *filename);
void dir_scan (char *basedir, char *destdir, int copy_all);
int process_recv(char *buf, int fd);
void net_dir_scan (int fd, char *basedir, int depth);
void strip_string(char *buf);
void split_string(char *buf, char *dest1, char *dest2);
int init_client(int port, char *servername);
void client_quit(int client_socket);
int client_dir_scan(int client_sd, char *src_dir, char *dest_dir, FILE *fd, int port, char *servername);
void sigchld_handler(int s);
void sighup_handler(int s);
void sigterm_handler(int s);
long long int size(char *file);
void getperms(char *filename, char *mode);
#ifndef HAVE_STRMODE
void strmode(mode_t mode, char *buffer);
#endif
void checkslash(char *path);
int netgetfile(char *src_file, char *dest_file, int port, char *servername, int filemode, int uid, int gid, int mtime, int atime);
int scan_config_file(char *filename);
int read_config(FILE *fp, char *keyword, char *value);
void strip_space(char *buffer);
int checkip(char *address);
void closeall(int fd);
int daemon(int nochdir, int noclose);
void logmsg(char *message);
int notify(char *filename);
int client_send_file(char *filename);
int server_recv_file(char *arguments, int fd);
void conv_src_to_dest(char *src, char *dest, char *fullfile, char *fulldest);
int server_dele(char *filename);
int server_mdir(char *directory);
int server_cmod(char *directory);
int dirdelete(char *directory);
int make_socket(uint16_t port);
int create_fd (int fd, int mode, char *path);
int daemonize (char *rundir);
void getowner (char *filename, char *owner, char *group);
int is_a_link (char *filename);
int client_check_exists (int client_sd, char *src_dir, char *dest_dir, FILE * fd,  int port, char *servername);
#ifdef HAVE_FNOTIFY
int set_monitor(char *directory);
#endif
void print_report();
void dump_config();
int getstat (char *filename, struct strstat *mystat);
void getstat2 (char *filename, struct strstat mystat);
int split_string2(char *test_string, struct split *splitted);
int find_parent(char *filename, char *parent);
void sig_alarm(int sig);

#endif
