/// Copyright Thomas Nagy 2007
/// License: QPL

#include <QAction>
#include <QtDebug>
#include <QTextEdit>
#include <QGridLayout>
#include <QLineEdit>
#include <QPalette>
#include <QX11Info>
#include<QCoreApplication>
#include <QToolButton>

#include "con.h"
#include "Prmza.h"
#include "Jelzpn.h"
#include "Ablak.h"
#include "Bnvzs.h"
#include"tslabels.h"

/*!
 * @praise Vishnu
 */
szkl::szkl(QWidget *felvnl,jelzpn *megkap) : QWidget(felvnl)
<%
	QGridLayout *tqrost=new QGridLayout();
	setLayout(tqrost);
	eler=new QLineEdit(this);

	kidlgz=megkap;

	vnl=new QTextEdit(this);
	tqrost->addWidget(eler,0,0);
	tqrost->addWidget(vnl,1,0,1,4);
	tqrost->setMargin(0);
	setMinimumHeight(30);

	new f7h(vnl->document());

	jlzpnt=0;

	QPalette adelk=eler->palette();
	adelk.setBrush(QPalette::Inactive,QPalette::Base,QColor(230,230,230));
	adelk.setBrush(QPalette::Disabled,QPalette::Base,QColor(230,230,230));
	eler->setPalette(adelk);
	vnl->setPalette(adelk);

	connect(eler,SIGNAL(textChanged(const QString&)),this,SLOT(hzzqjt(const QString &)));
	connect(vnl,SIGNAL(textChanged()),this,SLOT(nybnvn()));
	connect(vnl,SIGNAL(currentCharFormatChanged(const QTextCharFormat &)),
            this,SLOT(prl(const QTextCharFormat &)));

	mgmnkl=new QAction(lmzdul(ts_335),ts_336,this);
	mgmnkl->setShortcut(ts_337);
	mgmnkl->setCheckable(1);

	lnmtat=new QAction(lmzdul(ts_338),ts_339,this);
	lnmtat->setShortcut(ts_340);
	lnmtat->setCheckable(1);

	kket=new QAction(lmzdul(ts_341),ts_342,this);
	kket->setShortcut(ts_343);
	kket->setCheckable(1);

	QToolButton *klsirz=0;
	klsirz=new QToolButton(this);
	klsirz->setDefaultAction(mgmnkl);
	tqrost->addWidget(klsirz,0,1);

	klsirz=new QToolButton(this);
	klsirz->setDefaultAction(lnmtat);
	tqrost->addWidget(klsirz,0,2);

	klsirz=new QToolButton(this);
	klsirz->setDefaultAction(kket);
	tqrost->addWidget(klsirz,0,3);

	connect(mgmnkl,SIGNAL(triggered()),this,SLOT(fldlgz()));
	connect(lnmtat,SIGNAL(triggered()),this,SLOT(bprl()));
	connect(kket,SIGNAL(triggered()),this,SLOT(prmz()));
%>

void szkl::kelt(const zagv& tqrost)
<%
	int kivalt=tqrost[3].toInt();
	switch(kivalt)
	<%
		case ossz:
			jlzpnt=tqrost[2].toInt();
			break;

		case vlsztt:
			<%
				jlzpnt=tqrost[2].toInt();
				bool adelk=!jlzpnt;
				if(adelk)
				<%
					vnl->clear();
					eler->clear();
				%>
				else
				<%
					prmza *eljar=kidlgz->kket.value(jlzpnt);
					eler->setText(eljar->rabir);
					vnl->setHtml(eljar->mgzerz);
				%>

				vnl->setReadOnly(adelk);
				eler->setReadOnly(adelk);

				eler->setEnabled(!adelk);
				vnl->setEnabled(!adelk);

				mgmnkl->setEnabled(!adelk);
				lnmtat->setEnabled(!adelk);
				kket->setEnabled(!adelk);
			%>
			break;
		case krszt:
			<%
				int alafng=tqrost[2].toInt();
				if(jlzpnt)
				<%
					prmza *eljar=kidlgz->kket.value(jlzpnt);
					if(alafng==jlzpnt)
					<%
						eler->setText(eljar->rabir);
					%>
				%>
				jlzpnt=alafng;
			%>
			break;
		default:
			break;
	%>
%>

void szkl::hzzqjt(const QString & meghat)
<%
	if(!jlzpnt) return;
	prmza *eljar=kidlgz->kket.value(jlzpnt);

	bool adelk =(eljar->rabir!=meghat);
	eljar->rabir=meghat;
	if(adelk) kidlgz->mgmozt(jlzpnt,nztsvg);
%>

void szkl::nybnvn()
<%
	if(!jlzpnt) return;
	prmza *eljar=kidlgz->kket.value(jlzpnt);
	eljar->mgzerz=vnl->toHtml();
	eljar->kivalt=vnl->toPlainText().length();
%>

void szkl::fldlgz()
<%
	QTextCharFormat mrtdt;
	mrtdt.setFontWeight(mgmnkl->isChecked() ? QFont::Bold : QFont::Normal);
	kitzjl(mrtdt);
	nybnvn();
%>

void szkl::prmz()
<%
	QTextCharFormat mrtdt;
	mrtdt.setFontUnderline(kket->isChecked());
	kitzjl(mrtdt);
	nybnvn();
%>

void szkl::bprl()
<%
	QTextCharFormat mrtdt;
	mrtdt.setFontItalic(lnmtat->isChecked());
	kitzjl(mrtdt);
	nybnvn();
%>

void szkl::kitzjl(const QTextCharFormat &mrtdt)
<%
	QTextCursor cursor=vnl->textCursor();
	if(!cursor.hasSelection()) cursor.select(QTextCursor::WordUnderCursor);
	cursor.mergeCharFormat(mrtdt);
	vnl->mergeCurrentCharFormat(mrtdt);
%>

void szkl::prl(const QTextCharFormat &mrtdt)
<%
	QFont alkt=mrtdt.font();
	if(!fnqll) return;

	mgmnkl->setChecked(alkt.bold());
	lnmtat->setChecked(alkt.italic());
	kket->setChecked(alkt.underline());
%>

#include "Ablak.moc"

