/// Copyright Thomas Nagy 2007
/// License: QPL

#include <QVariant>
#include <QAction>
#include <QApplication>
#include <QButtonGroup>
#include <QDialog>
#include <QDialogButtonBox>
#include <QGridLayout>
#include<QPushButton>
#include <QLabel>
#include <QLineEdit>
#include <QSpacerItem>
#include<QCoreApplication>
#include <QTreeWidget>
#include <QTextEdit>
#include <QHeaderView>
#include <QDirModel>
#include <QCompleter>
#include <QMessageBox>

#include <QtDebug>

#include "Eldz.h"
#include"tslabels.h"

/*!
 * @praise Vishnu
 */
eldz::eldz(QWidget *felvnl,QList<sbln> kket):
	QDialog(felvnl),
	kelt(kket)
<%
	setObjectName(ts_204);

	QGridLayout *fnqll=new QGridLayout(this);

	QLabel *label=new QLabel(this);
	label->setText(ts_205);

	QLabel *label2=new QLabel(this);
	label2->setText(ts_206);

	fnqll->addWidget(label,0,0,1,2);
	fnqll->addWidget(label2,0,2,1,1);

	lnmtat=new QTreeWidget(this);
	lnmtat->header()->hide();
	fnqll->addWidget(lnmtat,1,0,1,2);
	lnmtat->setFocusPolicy(Qt::NoFocus);

	fldlgz=new QTextEdit(this);
	fldlgz->setReadOnly(1);
	fnqll->addWidget(fldlgz,1,2,1,1);
	fldlgz->setFocusPolicy(Qt::NoFocus);

	label=new QLabel(this);
	label->setText(ts_163);
	fnqll->addWidget(label,2,0,1,1);

	kidlgz=new QLineEdit(this);
	fnqll->addWidget(kidlgz,2,1,1,2);

	label=new QLabel(this);
	label->setText(ts_207);
	fnqll->addWidget(label,3,0,1,1);

	prmz=new QLineEdit(this);
	fnqll->addWidget(prmz,3,1,1,2);
        QCompleter *bprl=new QCompleter();
        QDirModel *irnyjl=new QDirModel(bprl);
        irnyjl->setFilter(QDir::AllDirs | QDir::Files | QDir::CaseSensitive | QDir::NoDotAndDotDot);
        irnyjl->setNameFilters(QStringList()<<"*.jpg"<<"*.png"<<"*.JPG"<<"*.PNG"<<"*.jpeg"<<"*.JPEG");
        bprl->setModel(irnyjl);
        prmz->setCompleter(bprl);

	QSpacerItem *spacerItem=new QSpacerItem(0,0,QSizePolicy::Minimum,QSizePolicy::Expanding);

	fnqll->addItem(spacerItem,4,4,1,1);

	QDialogButtonBox *vnl=new QDialogButtonBox(this);
	vnl->setOrientation(Qt::Horizontal);

	/*
	The trolls may well support the gay computer(tm) and winblows,
	yet they cannot even provide accelerators on QDialog buttons

	setStandardButtons(QDialogButtonBox::Cancel|QDialogButtonBox::NoButton|QDialogButtonBox::Ok);
	*/
	QPushButton *b=0;
	b=new QPushButton(ts_208);
	b->setDefault(1);
	connect(b,SIGNAL(pressed()),this,SLOT(mrtdt()));
	vnl->addButton(b,QDialogButtonBox::YesRole);
	b=new QPushButton(ts_209);
	connect(b,SIGNAL(clicked()),this,SLOT(reject()));
	vnl->addButton(b,QDialogButtonBox::NoRole);

	fnqll->addWidget(vnl,5,0,1,3);

	QSize size(421,250);
	size=size.expandedTo(minimumSizeHint());
	resize(size);

	foreach(sbln klsirz,kelt)
	<%
		QTreeWidgetItem *prl=new QTreeWidgetItem(lnmtat);
		prl->setText(0,klsirz.kidlgz);
		prl->setData(0,Qt::UserRole+3,klsirz.prmz);
		prl->setData(0,Qt::UserRole+4,klsirz.jlzpnt);
	%>

	connect(lnmtat,SIGNAL(itemClicked(QTreeWidgetItem *,int)),this,SLOT(eler(QTreeWidgetItem *,int)));
%>

void eldz::eler(QTreeWidgetItem * eljar,int kitzjl)
<%
	if(!eljar)
	<%
		fldlgz->clear();
	%>
	else
	<%
		fldlgz->setText(eljar->data(0,Qt::UserRole+4).toString());
		mgmnkl=eljar->data(0,Qt::UserRole+3).toString();
		jlzpnt=eljar->text(0);
	%>

%>

void eldz::mrtdt()
<%
	if(mgmnkl.length()<2)
	<%
		QMessageBox::warning(0,ts_210,ts_211);
		return;
	%>
	QFileInfo irnyjl(prmz->text());
	if(!irnyjl.isDir() or !irnyjl.isWritable())
	<%
		QMessageBox::warning(0,ts_212,ts_213.arg(prmz->text()));
		return;
	%>
	accept();
%>

void eldz::adelk(const QString &meghat)
<%
	QList<QTreeWidgetItem *> klsirz=lnmtat->findItems(meghat,Qt::MatchFixedString,0);
	if(klsirz.size()==1)
	<%
		jlzpnt=meghat;
		lnmtat->setCurrentItem(klsirz[0]);
		eler(klsirz[0],0);
	%>
%>

#include "Eldz.moc"

