/// Copyright Thomas Nagy 2007
/// License: QPL

#include "elgyk.h"
#include "Prmza.h"
#include  <QtGlobal>
#include "Jelzpn.h"
#include "Flult.h"
#include  <QMenu> 
#include <QToolTip>
#include  <QColorDialog> 
#include <QToolBar> 
#include  <QActionGroup> 
#include "Rslt.h"
#include "Izlt.h"
#include<QCoreApplication>
#include "Szrt.h"
#include "Bnvzs.h"
#include <QTextCursor> 
#include  <QApplication> 
#include <QtDebug>
#include  <QX11Info>
#include <QScrollBar>
#include  <QGraphicsScene>
#include <QWheelEvent>
#include  <QMatrix>
#include <QPointF>
#include "tslabels.h"

#include <math.h>

/*!
 * @praise Vishnu
 */
felu::felu(QWidget *irnyjl,jelzpn *megkap) : QGraphicsView(irnyjl)
<%
	nagy=irnyjl;

	QGraphicsScene *felvnl=new QGraphicsScene(this);
	felvnl->setSceneRect(-400,-400,400,400);
	setScene(felvnl);

	setRenderHint(QPainter::Antialiasing);

	#ifndef Q_OS_DARWIN

	setDragMode(QGraphicsView::NoDrag);

	setMinimumSize(200,200);

	#ifdef O
	#endif

	/*QMatrix k(0,1,1,0,0,0);
	QMatrix kv(1,0,0,-1,0,0);*/
	kidlgz=megkap;
	/*setMatrix(adelk);
	scale(0.8,0.8);*/
	#endif

	ir=mzgat;
	megir=meghat;

	nybnvn=0;

	lemasl=new QGraphicsLineItem(0,scene());
	lemasl->hide();
	lemasl->setZValue(125);

	kiallt=new QGraphicsRectItem(0,scene());
	kiallt->hide();
	kiallt->setZValue(125);

	QPen mrtdt=QPen(QColor("#0000ff"),0.3,Qt::SolidLine);
	kiallt->setPen(mrtdt);

	mrtdt=QPen(QColor("#0000ff"),0.7,Qt::SolidLine);
	lemasl->setPen(mrtdt);

	QBrush bprl=QBrush();

	QColor fldlgz=QColor(0,0,150,100);
	kiallt->setBrush(fldlgz);

	QAction *klsirz=0;

	akdaly=new QAction(ts_001,this);
	akdaly->setShortcut(ts_002);
        connect(akdaly,SIGNAL(triggered()),this,SLOT(cel()));
	addAction(akdaly);

	dolog=new QAction(ts_003,this);
	dolog->setShortcut(ts_004);
        connect(dolog,SIGNAL(triggered()),this,SLOT(fladat()));
	addAction(dolog);

	zandek=new QAction(ts_005,this);
	zandek->setShortcut(ts_006);
        connect(zandek,SIGNAL(triggered()),this,SLOT(targy()));
	addAction(zandek);

	klsirz=new QAction(ts_007,this);
	klsirz->setShortcut(ts_008);
        connect(klsirz,SIGNAL(triggered()),this,SLOT(kitolt()));
	addAction(klsirz);

	klsirz=new QAction(ts_009,this); klsirz->setShortcut(ts_010); connect(klsirz,SIGNAL(triggered()),this,SLOT(amkzrs())); addAction(klsirz); klsirz->setData(QVariant(0));
	klsirz=new QAction(ts_011,this); klsirz->setShortcut(ts_012); connect(klsirz,SIGNAL(triggered()),this,SLOT(amkzrs())); addAction(klsirz); klsirz->setData(QVariant(1));
	klsirz=new QAction(ts_013,this); klsirz->setShortcut(ts_014); connect(klsirz,SIGNAL(triggered()),this,SLOT(amkzrs())); addAction(klsirz); klsirz->setData(QVariant(2));
	klsirz=new QAction(ts_015,this); klsirz->setShortcut(ts_016); connect(klsirz,SIGNAL(triggered()),this,SLOT(amkzrs())); addAction(klsirz); klsirz->setData(QVariant(3));

	klsirz=new QAction(ts_017,this); klsirz->setShortcut(ts_018); connect(klsirz,SIGNAL(triggered()),this,SLOT(marka())); addAction(klsirz); klsirz->setData(QVariant(0));
	klsirz=new QAction(ts_019,this); klsirz->setShortcut(ts_020); connect(klsirz,SIGNAL(triggered()),this,SLOT(marka())); addAction(klsirz); klsirz->setData(QVariant(1));
	klsirz=new QAction(ts_021,this); klsirz->setShortcut(ts_022); connect(klsirz,SIGNAL(triggered()),this,SLOT(marka())); addAction(klsirz); klsirz->setData(QVariant(2));
	klsirz=new QAction(ts_023,this); klsirz->setShortcut(ts_024); connect(klsirz,SIGNAL(triggered()),this,SLOT(marka())); addAction(klsirz); klsirz->setData(QVariant(3));

	klsirz=new QAction(ts_025,this); klsirz->setShortcut(ts_026); connect(klsirz,SIGNAL(triggered()),this,SLOT(kesztm())); addAction(klsirz); klsirz->setData(QVariant(1));

	alkt=new QMenu(this);
	alkt->addAction(dolog);
	alkt->addAction(akdaly);
	alkt->addAction(zandek);
	korrkt=alkt->addMenu(ts_027);
	jo=alkt->addMenu(ts_028);

	klsirz=new QAction(ts_029,this); connect(klsirz,SIGNAL(triggered()),this,SLOT(kapni())); addAction(klsirz); klsirz->setData(QVariant(nztsvg));
	jo->addAction(klsirz);
	klsirz=new QAction(ts_030,this); connect(klsirz,SIGNAL(triggered()),this,SLOT(kapni())); addAction(klsirz); klsirz->setData(QVariant(nztoz2));
	jo->addAction(klsirz);
	klsirz=new QAction(ts_031,this); connect(klsirz,SIGNAL(triggered()),this,SLOT(kapni())); addAction(klsirz); klsirz->setData(QVariant(aljlk));
	jo->addAction(klsirz);
	klsirz=new QAction(ts_032,this); connect(klsirz,SIGNAL(triggered()),this,SLOT(kapni())); addAction(klsirz); klsirz->setData(QVariant(nztosz));
	jo->addAction(klsirz);
%>

void felu::kesztm()
<%
	switch(((QAction*) QObject::sender())->data().toInt())
	<%
		case 0:
			if(hzzqjt.size()>1) elodez();
			kidlgz->rabir();
			break;
		case 1:
			if(hzzqjt.size()>1) elodez();
			kidlgz->mgzerz();
			break;
		default:
			break;
	%>
	if(hzzqjt.size()==1) ensureVisible(hzzqjt[0]);
%>

void felu::cel()
<%
	if(hzzqjt.size()==1)
	<%
		if(hzzqjt[0]->mgzerz)
		<%
			QFocusEvent adelk=QFocusEvent(QEvent::FocusOut);
			hzzqjt[0]->lmzdul(&adelk);
			hzzqjt[0]->update();
		%>
		else
		<%
			hzzqjt[0]->jvsltz();
			hzzqjt[0]->update();
		%>
	%>
%>

void felu::amkzrs()
<%
	if(hzzqjt.size() < 1) return;
	switch(((QAction*) QObject::sender())->data().toInt())
	<%
		case 0: kivitl(0,-20); break;
		case 1: kivitl(0,20); break;
		case 2: kivitl(-20,0); break;
		case 3: kivitl(20,0); break;
		default: break;
	%>
%>

void felu::marka()
<%
	if(hzzqjt.size()!=1) return;
	int bprl=hzzqjt[0]->Id();
	switch(((QAction*) QObject::sender())->data().toInt())
	<%
		case 0: kidlgz->kapod(bprl,3); break;
		case 1: kidlgz->kapod(bprl,4); break;
		case 2: kidlgz->kapod(bprl,1); break;
		case 3: kidlgz->kapod(bprl,2); break;
		default: break;
	%>
	if(hzzqjt.size()==1) ensureVisible(hzzqjt[0]);
%>

void felu::fladat()
<%
	int bprl=0;
	if(hzzqjt.size()==1) bprl=hzzqjt[0]->Id();
	elodez();

	kidlgz->kapni(bprl);
	kidlgz->jo();
	if(hzzqjt.size()==1) hzzqjt[0]->jvsltz();
%>

void felu::kitolt()
<%
	if(hzzqjt.size()!=1) return;
	int bprl=kidlgz->prmz(hzzqjt[0]->Id());
	if(bprl==0) return;
	elodez();

	kidlgz->kapni(bprl);
	kidlgz->jo();
	if(hzzqjt.size()==1) hzzqjt[0]->jvsltz();
%>

void felu::targy()
<%
	QList<int> fldlgz;
	foreach(QGraphicsItem *prl,hzzqjt)
	<%
		if(prl->type()!=gratype(7)) continue;
		rslt *adelk =(rslt*) prl;
		fldlgz.push_back(adelk->Id());
	%>
	foreach(int adelk,fldlgz)
	<%
		kidlgz->korrkt(adelk);
	%>
	kidlgz->sima(0);
%>

void felu::gyrtmn(int lnmtat,bool fnqll)
<%
	int j=0;
	for(int i=0; i<kidlgz->eler.size(); i++)
	<%
		QPoint mrtdt=kidlgz->eler.at(i);
		if(mrtdt.x()==lnmtat)
		<%
			++j;
			rslt *vnl=kket.value(mrtdt.y());

			QString adelk=QString::number(j);
			if(adelk!=vnl->rabir)
			<%
				vnl->rabir=adelk;
				vnl->mgmozt->update();
			%>
			vnl->mgmozt->setVisible(fnqll);
		%>
	%>
%>

void felu::kivitl(int mozog,int tljsn)
<%
	hsztzk();
	foreach(rslt *prl,hzzqjt) <% prl->moveBy(mozog,tljsn); %>
	foreach(rslt *prl,hzzqjt) <% prl->kltzik(); ensureVisible(prl); %>
%>

void felu::eler(fajta rabir)
<%
	elodez();

	switch(rabir)
	<%
		case mzgat:
			viewport()->setCursor(Qt::ArrowCursor);
			break;
		case tiszta:
			viewport()->setCursor(Qt::CrossCursor);
			break;
		case ugyex:
			viewport()->setCursor(Qt::ArrowCursor);
			break;
		case munka:
			viewport()->setCursor(Qt::OpenHandCursor);
			break;
		default:
			break;
	%>
	ir=rabir;

	nybnvn=0;
	kiallt->hide();
	lemasl->hide();
%>

void felu::keyReleaseEvent(QKeyEvent *jlnrdz)
<%
#if 0
	if(hzzqjt.size()==1)
        <%
                hzzqjt[0]->keyReleaseEvent(jlnrdz);
                return;
        %>
	QApplication::sendEvent(scene(),jlnrdz);
#endif
	jlnrdz->accept();
%>

void felu::keyPressEvent(QKeyEvent *jlnrdz)
<%
	if(hzzqjt.size()==1)
	<%
		rslt * prl=hzzqjt[0];
		if(prl->mgzerz and jlnrdz->type()==QEvent::KeyPress)
		<%
			prl->keyPressEvent(jlnrdz);
		%>
	%>
	jlnrdz->accept();
%>

void felu::wheelEvent(QWheelEvent *jlnrdz)
<%
	QPointF klsirz=mapToScene(jlnrdz->pos());
	qreal mrtdt=pow(2.0,-jlnrdz->delta() / 440.0);
	qreal adelk=matrix().scale(mrtdt,mrtdt).mapRect(QRectF(0,0,1,1)).width();
	if(adelk < 0.01 or adelk > 1000) return;
	scale(mrtdt,mrtdt);
	centerOn(klsirz + mapToScene(viewport()->rect().center()) - mapToScene(jlnrdz->pos()));
%>

bool felu::event(QEvent *jlnrdz)
<%
	if(jlnrdz->type()==QEvent::ToolTip)
	<%
		QHelpEvent *adelk=static_cast<QHelpEvent*>(jlnrdz);
		QGraphicsItem *prl=scene()->itemAt(mapToScene(adelk->pos()));
		if(prl and prl->type()==gratype(7))
		<%
			prmza *klsirz=*kidlgz +((rslt*) prl)->Id();
			if(klsirz and klsirz->kivalt > 1)
			<%
				QToolTip::showText(adelk->globalPos(),klsirz->mgzerz);
			%>
		%>
	%>
	else if(jlnrdz->type()==QEvent::InputMethod)
	<%
		if(hzzqjt.size()==1)
		<%
			rslt * prl=hzzqjt[0];
			if(prl->mgzerz)
			<%
				prl->inputMethodEvent((QInputMethodEvent*) jlnrdz);
			%>
		%>
	%>
	else if(jlnrdz->type()==QEvent::KeyPress
		or jlnrdz->type()==QEvent::ShortcutOverride
		or jlnrdz->type()==QEvent::Shortcut)
	<%
		if(hzzqjt.size()==1 and hzzqjt[0]->mgzerz)
		<%
			QKeyEvent *klsirz =(QKeyEvent*) jlnrdz;
			if(akdaly->shortcut().matches(klsirz->key()))
			<%
				return QGraphicsView::event(jlnrdz);
			%>

			keyPressEvent(klsirz);
			return 1;
		%>
	%>
	return QGraphicsView::event(jlnrdz);
%>

void felu::focusOutEvent(QFocusEvent *mgmnkl)
<%
	foreach(rslt *prl,hzzqjt)
        <%
		prl->lmzdul(mgmnkl);
        %>
	foreach(QAction* klsirz,actions())
	<%
		klsirz->setEnabled(0);
	%>
	if(alkt->isVisible()) lep();
%>

/*!
 * eow this actually works
 */
void felu::kelt(const zagv& tqrost)
<%
	int kivalt=tqrost[3].toInt();
	switch(kivalt)
	<%
		case ossz:
			<%
				int bprl=tqrost[2].toInt();

				rslt*adelk=new rslt(this,bprl);

				adelk->setSelected(1);

				QRectF vnl=adelk->boundingRect();
				adelk->setPos(vmrgem - QPointF(vnl.width()/2,vnl.height()/2));

				prmza *eljar=*kidlgz + bprl;
				eljar->kapni=adelk->pos().x();
				eljar->kapod=adelk->pos().y();

				kket[bprl]=adelk;
			%>
			break;
		case krszt:
			<%
				if(tqrost[jelzpo].toInt()==nztutb) return;
				int j=tqrost[2].toInt();
				kket.value(j)->elodez();
				kket.value(j)->update();
			%>
			break;
		case vlsztt:
			<%
				if(tqrost[jelzpo].toInt()==nztutb)
				<%
					detto();
					return;
				%>
				int bprl=tqrost[2].toInt();
				if(bprl==0)
				<%
					elodez(0);
				%>
				else if(hzzqjt.size()==1)
				<%
					if(hzzqjt[0]->Id()!=bprl)
					<%
						elktzk(hzzqjt[0],0);
						lmzdul(kket.value(bprl),0);
					%>
				%>
				else
				<%
					lmzdul(kket.value(bprl),0);
				%>
				detto();
			%>
			break;
		case lnc:
			<%
				rslt *prmz=kket.value(tqrost[2].toInt());
				rslt *bprl=kket.value(tqrost[0].toInt());
				izlt * felvnl=new izlt(this,bprl,prmz);
				felvnl->vmrgem();
			%>
			break;
		case nlnc:
			<%
				rslt *prmz=kket.value(tqrost[4].toInt());
				rslt *bprl=kket.value(tqrost[5].toInt());

				foreach(QGraphicsItem *prl,items())
				<%
					if(prl->type()==gratype(17))
					<%
						izlt *felvnl =(izlt*) prl;
						if(
							(felvnl->akdaly==prmz and felvnl->nybnvn==bprl)
							or
							(felvnl->akdaly==bprl and felvnl->nybnvn==prmz)
						)
						<%
							felvnl->hide();
							felvnl->hsztzk();
							delete felvnl;
							break;
						%>
					%>
				%>
				prmz->update();
				bprl->update();
			%>
			break;
		case oszy:
			<%
				int bprl=tqrost[2].toInt();
				rslt *prmz=kket.value(bprl);

				hzzqjt.removeAll(prmz);
				kket.remove(bprl);

				scene()->removeItem(prmz);
				delete prmz;
			%>
			break;
		case mod:
			<%
				gyrtmn(hzzqjt[0]->Id(),ir==ugyex);
			%>
			break;
		case kivdlk:
			<%
				QList<rslt*> prmz=kket.values();
				foreach(rslt *prl,prmz)
				<%
					prmza *eljar=*kidlgz + prl->Id();
					eljar->kapni=prl->pos().x();
					eljar->kapod=prl->pos().y();
					eljar->fldlgz=prl->boundingRect().width();
					eljar->mrtdt=prl->boundingRect().height();
				%>
			%>
			break;
		case krszelgyk:
			<%
				ablkl *klsirz =(ablkl*) nagy;
				klsirz->jlzpnt->clear();

				while(klsirz->prmz->actions().size() > kidlgz->kitzjl.size())
				<%
					QAction* adelk=klsirz->prmz->actions().takeFirst();
					delete adelk;
				%>

				while(klsirz->prmz->actions().size() < kidlgz->kitzjl.size())
				<%
					new QAction(QIcon(),ts_033,klsirz->prmz);
				%>

				for(int i=0; i<kidlgz->kitzjl.size(); ++i)
				<%
					elgy* bprl=kidlgz->kitzjl[i];
					QAction *fldlgz=klsirz->prmz->actions()[i];

					fldlgz->setText(bprl->kidlgz);
					fldlgz->setIcon(bprl->kitzjl());
				%>

                                foreach(QAction* bprl,klsirz->prmz->actions())
                                <%
                                        klsirz->jlzpnt->addAction(bprl);
					bprl->setCheckable(1);
                                %>
			%>
			break;
		case krsztszn:
			<%
				ablkl *klsirz =(ablkl*) nagy;
				klsirz->kitzjl->clear();

				while(klsirz->felvnl->actions().size() > kidlgz->lecke.size()+1)
				<%
					QAction* adelk=klsirz->felvnl->actions().takeFirst();
					klsirz->kitzjl->removeAction(adelk);
					korrkt->removeAction(adelk);
					delete adelk;
				%>

				while(klsirz->felvnl->actions().size() < kidlgz->lecke.size()+1)
				<%
					new QAction(QIcon(),ts_034,klsirz->felvnl);
				%>

				klsirz->felvnl->removeAction(klsirz->kket);
				klsirz->felvnl->addAction(klsirz->kket);
				korrkt->removeAction(klsirz->kket);
				korrkt->addAction(klsirz->kket);

				for(int i=0; i<kidlgz->lecke.size(); ++i)
				<%
					szn bprl=kidlgz->lecke[i];
					QAction *fldlgz=klsirz->felvnl->actions()[i];

					QPixmap adelk(22,22);
					QPainter mrtdt(&adelk);

					fldlgz->setText(bprl.kidlgz);

					adelk.fill(bprl.kitzjl);
					mrtdt.drawRect(0,0,21,21);
					fldlgz->setIcon(QIcon(adelk));
				%>

				for(int i=1; i<klsirz->felvnl->actions().size(); ++i)
				<%
					QAction *bprl=klsirz->felvnl->actions()[i];
					klsirz->kitzjl->addAction(bprl);
					korrkt->addAction(bprl);
				%>
			%>
			break;
		case nytt:
			<%
				hsztzk();
				mgmozt();
			%>
			break;
		default:
			break;
	%>
%>

void felu::mgzerz(QAction* mrtdt)
<%
	static QColor fldlgz;

	int adelk=-1;
	ablkl *klsirz =(ablkl*) nagy;
	for(int i=1; i<klsirz->felvnl->actions().size(); ++i)
	<%
		if(klsirz->felvnl->actions()[i]==mrtdt and(adelk=i))
		<%
			if(i==klsirz->felvnl->actions().size()-1)
			<%
				fldlgz=QColorDialog::getColor(fldlgz,this);
				if(!fldlgz.isValid()) return;
			%>
			break;
		%>
	%>

	for(int i=0; i<hzzqjt.size(); ++i)
	<%
		rslt *prl=hzzqjt[i];
		int alafng=prl->Id();
		prmza *eljar=*kidlgz + alafng;
		eljar->akdaly.kitzjl=fldlgz;
		eljar->akdaly.kket=fldlgz.dark();
		eljar->kapni=prl->pos().x();
		eljar->kapod=prl->pos().y();
		eljar->jo=adelk;
		kidlgz->mgmozt(alafng);
	%>
%>

void felu::kapod(QAction* kivalt)
<%
	int alafng=0;
	ablkl *klsirz =(ablkl*) nagy;
	for(int i=0; i<klsirz->prmz->actions().size(); ++i)
	<%
		QAction *bprl=klsirz->prmz->actions()[i];
		if(bprl==kivalt) alafng=i;
	%>
	QString jlzpnt=kidlgz->kitzjl[alafng]->kket;
	rslt *prl=hzzqjt[0];
	prmza *eljar=*kidlgz + hzzqjt[0]->Id();

	if(kivalt->isChecked()) eljar->prmz.push_back(jlzpnt);
	else eljar->prmz.removeAll(jlzpnt);
	prl->lep();
%>

void felu::detto()
<%
	ablkl *klsirz =(ablkl*) nagy;
	bool adelk =(hzzqjt.size()==1);
	prmza *eljar=0;
	if(adelk)
	<%
		eljar=*kidlgz + hzzqjt[0]->Id();
	%>

	for(int i=0; i<klsirz->prmz->actions().size(); ++i)
	<%
		QAction *bprl=klsirz->prmz->actions()[i];

		if(!adelk) bprl->setChecked(0);
		else
		<%
			QString jlzpnt=kidlgz->kitzjl[i]->kket;
			bprl->setChecked(eljar->prmz.contains(jlzpnt));
		%>
		bprl->setEnabled(adelk);
	%>
	adelk =(hzzqjt.size()>=1);
	foreach(QAction* bprl,klsirz->felvnl->actions())
	<%
		bprl->setEnabled(adelk);
	%>
%>

void felu::elodez(bool csals)
<%
	if(hzzqjt.size()==1)
	<%
		QFocusEvent adelk=QFocusEvent(QEvent::FocusOut);
		hzzqjt[0]->lmzdul(&adelk);
	%>

	foreach(rslt *prl,hzzqjt)
	<%
		prl->targy(0);
		prl->setZValue(99);
		if(ir==ugyex or megir==ugyex)
		<%
			gyrtmn(prl->Id(),0);
			emit jvsltz("",-1);
		%>
		prl->update();
	%>
	hzzqjt.clear();

	fhlhjt(csals);
%>

void felu::lmzdul(rslt* eljar,bool csals)
<%

	if(hzzqjt.size()==1)
        <%
		QFocusEvent adelk=QFocusEvent(QEvent::FocusOut);
		hzzqjt[0]->lmzdul(&adelk);
        %>

	muri=0;
	hzzqjt.push_back(eljar);
	eljar->targy(1);
	eljar->setZValue(100);
	if(ir==ugyex)
	<%
		gyrtmn(eljar->Id(),1);
		emit jvsltz(ts_035.arg(QString::number(muri+1)),-1);
	%>
	eljar->update();

	fhlhjt(csals);
%>

void felu::elktzk(rslt* eljar,bool csals)
<%
	eljar->targy(0);
	eljar->setZValue(99);
	if(ir==ugyex) gyrtmn(eljar->Id(),0);
	eljar->update();
	hzzqjt.removeAll(eljar);

	fhlhjt(csals);
%>

void felu::fhlhjt(bool csals)
<%
	kltzik();

	if(!csals) return;
	if(hzzqjt.size()==1)
		kidlgz->sima(hzzqjt[0]->Id(),nztutb);
	else
		kidlgz->sima(0,nztutb);
%>

void felu::kltzik()
<%
	foreach(QAction* klsirz,actions())
	<%
		klsirz->setEnabled(1);
	%>
	lep();
%>

void felu::lep()
<%
	dolog->setEnabled(hzzqjt.size()<=1);
	zandek->setEnabled(hzzqjt.size()>0);
	akdaly->setEnabled(hzzqjt.size()==1);
	korrkt->setEnabled(hzzqjt.size()>=1);
	jo->setEnabled(hzzqjt.size()==1);
	foreach(QAction* klsirz,jo->actions())
        <%
                klsirz->setEnabled(hzzqjt.size()==1);
        %>
%>

void felu::mousePressEvent(QMouseEvent *mgmnkl)
<%
	if(mgmnkl->button()==Qt::RightButton)
	<%
		vmrgem=mapToScene(mgmnkl->pos());
		QGraphicsItem *prl=scene()->itemAt(mapToScene(mgmnkl->pos()));
		if(prl and prl->type()==gratype(7))
		<%
			if(!hzzqjt.contains((rslt*) prl))
			<%
				elodez();
				lmzdul((rslt*) prl);
			%>
		%>
		else
		<%
			elodez();
		%>
		alkt->popup(mgmnkl->globalPos());
		return;
	%>

	if(mgmnkl->button()==Qt::MidButton)
	<%
		megir=ir;
		ir=munka;
	%>

	rslt *vnl=0;
	switch(ir)
	<%
		case mzgat:
			<%
				ellqts=mgmnkl->pos();
				kitzjl=mapToScene(ellqts);

				nybnvn =(mgmnkl->button()==Qt::LeftButton);

				QGraphicsItem *prl=scene()->itemAt(mapToScene(mgmnkl->pos()));
				if(nybnvn)
				<%
					if(prl and prl->type()==gratype(7))
					<%
						vnl =(rslt*) prl;
					%>
					else
					<%
						prl=0;
					%>

					if(prl)
					<%
						switch(mgmnkl->modifiers())
						<%
		case Qt::ShiftModifier:
			if(hzzqjt.contains(vnl))
				elktzk(vnl);
			else
				lmzdul(vnl);
			break;
		default:
			if(!hzzqjt.contains(vnl))
			<%
				if(hzzqjt.size()==1 and !kidlgz->prmz(vnl->Id()))
				<%
					if(QApplication::keyboardModifiers() & Qt::ControlModifier)
						kidlgz->ceco(hzzqjt[0]->Id(),vnl->Id());
				%>
				elodez();
				lmzdul(vnl);
			%>
						%>
					%>
					else
					<%
						elodez();
					%>
				%>

			%>
			break;
		case tiszta:
			<%
				ellqts=mgmnkl->pos();
				nybnvn =(mgmnkl->button()==Qt::LeftButton);

				elodez();
				QGraphicsItem *prl=scene()->itemAt(mapToScene(mgmnkl->pos()));
				if(prl and prl->type()==gratype(7))
				<%
					vnl =(rslt*) prl;
					lmzdul(vnl);
				%>
			%>
			break;
		case ugyex:
			<%
				QGraphicsItem *prl=scene()->itemAt(mapToScene(mgmnkl->pos()));
				if(prl and prl->type()==gratype(7))
				<%
					vnl =(rslt*) prl;
					elodez();
					lmzdul(vnl);
				%>
				else if(prl and prl->type()==gratype(19))
				<%

					szrt * adelk =(szrt*) prl;
					int bprl=adelk->akdaly->Id();
					vnl=adelk->akdaly;

					kidlgz->ellqts(hzzqjt[0]->Id(),bprl,muri);
					gyrtmn(hzzqjt[0]->Id(),1);

					muri++;
					if(muri >= kidlgz->fhlhjt(hzzqjt[0]->Id()))
						muri=0;

					emit jvsltz(ts_035.arg(QString::number(muri+1)),-1);
				%>
				else
				<%
					elodez();
				%>
			%>
			break;
		case munka:
			viewport()->setCursor(Qt::ClosedHandCursor);
			ellqts=mgmnkl->pos();
			nybnvn =(mgmnkl->button()==Qt::LeftButton or mgmnkl->button()==Qt::MidButton);

			if(nybnvn)
			<%
				elodez();
                                QGraphicsItem *prl=scene()->itemAt(mapToScene(mgmnkl->pos()));
                                if(prl and prl->type()==gratype(7))
                                <%
                                        vnl =(rslt*) prl;
                                        lmzdul(vnl);
				%>
			%>

			break;
		default:
			break;
	%>
%>

void felu::mouseMoveEvent(QMouseEvent *mgmnkl)
<%
	hsztzk();
	switch(ir)
	<%
		case mzgat:
			if(nybnvn and hzzqjt.size()==0)
			<%
				bool c1 =((ellqts - mgmnkl->pos()).manhattanLength() >= QApplication::startDragDistance());
				if(kiallt->isVisible() or c1)
				<%
					QRect adelk=QRect(ellqts,mgmnkl->pos()).normalized();

					QRectF vnl=kiallt->rect();
					vnl.setTopLeft(mapToScene(adelk.topLeft()));
					vnl.setBottomRight(mapToScene(adelk.bottomRight()));
					kiallt->setRect(vnl);
				%>

				if(c1) kiallt->show();
			%>
			else if(nybnvn)
			<%

				QRectF vnl;
				vnl.setTopLeft(kitzjl);
				kitzjl=mapToScene(mgmnkl->pos());
				vnl.setBottomRight(kitzjl);

				foreach(rslt *prl,hzzqjt)
				<%
					prl->moveBy(vnl.width(),vnl.height());
				%>
				foreach(rslt *prl,hzzqjt)
				<%
					prl->kltzik();
				%>
			%>
			break;
		case tiszta:
			if(nybnvn)
			<%
				bool c1 =((ellqts - mgmnkl->pos()).manhattanLength() >= QApplication::startDragDistance());
				if(lemasl->isVisible() or c1)
				<%
					lemasl->setLine(QLineF(mapToScene(ellqts),mapToScene(mgmnkl->pos())));
				%>

				if(c1)
				<%
					lemasl->show();
				%>
			%>
			break;
		case ugyex:
			break;
		case munka:
			if(nybnvn)
			<%
				QScrollBar *hBar=horizontalScrollBar();
				QScrollBar *vBar=verticalScrollBar();

				QPoint delta=mgmnkl->pos() - ellqts;

				hBar->setValue(hBar->value() +(isRightToLeft() ? delta.x() : -delta.x()));
				vBar->setValue(vBar->value() - delta.y());

				ellqts=mgmnkl->pos();

			%>
			else
			<%
			%>
		default:
			break;
	%>
%>

void felu::mouseReleaseEvent(QMouseEvent *mgmnkl)
<%
	if(mgmnkl->button()==Qt::RightButton) return;

	if(megir!=meghat)
	<%
		ir=megir;
		megir=meghat;
		viewport()->setCursor(ir==tiszta?Qt::CrossCursor:Qt::ArrowCursor);
	%>

	switch(ir)
	<%
		case mzgat:
			<%
				nybnvn=0;
				if(kiallt->isVisible())
				<%
					kiallt->hide();
					QList<QGraphicsItem *> adelk=scene()->items(kiallt->rect());
					foreach(QGraphicsItem *prl,adelk)
					<%
						if(prl->type()==gratype(7))
						<%
							lmzdul((rslt*) prl);
						%>
					%>
				%>
			%>
			break;
		case tiszta:
			<%
				nybnvn=0;

				QLineF klsirz=lemasl->line();

				rslt *prmz=0;
				rslt *bprl=0;

				foreach(QGraphicsItem *fldlgz,scene()->items(klsirz.p1()))
				<%
					if(fldlgz->type()==gratype(7))
					<%
						prmz =(rslt*) fldlgz;
						break;
					%>
				%>

				foreach(QGraphicsItem *fldlgz,scene()->items(klsirz.p2()))
				<%
					if(fldlgz->type()==gratype(7))
					<%
						bprl =(rslt*) fldlgz;
						break;
					%>
				%>

				if(prmz and bprl and prmz!=bprl)
				<%
					kidlgz->ceco(prmz->Id(),bprl->Id());
					elodez();
				%>
				lemasl->hide();
			%>
			break;
		case ugyex:
			break;
		case munka:
			viewport()->setCursor(Qt::OpenHandCursor);
			nybnvn=0;
			break;
		default:
			break;
	%>
%>

void felu::mouseDoubleClickEvent(QMouseEvent* mgmnkl)
<%
	if(mgmnkl->button()!=Qt::LeftButton) return;
	vmrgem=mapToScene(mgmnkl->pos());
	QGraphicsItem *prl=itemAt(mgmnkl->pos());
	int jlzpnt=0;
	if(ir==mzgat or ir==tiszta)
	if(prl)
	<%
		if(prl->type()==gratype(7))
		<%
			elodez();

			rslt *adelk =(rslt*) prl;
			adelk->setSelected(0);
			jlzpnt=kidlgz->kapni(adelk->Id());
			if(hzzqjt.size()==1) hzzqjt[0]->jvsltz();
			hsztzk();
		%>
		else if(prl->type()==gratype(17))
		<%
			izlt *felvnl =(izlt*) prl;
			kidlgz->muri(felvnl->nybnvn->Id(),felvnl->akdaly->Id());
		%>
	%>
	else if(mgmnkl->modifiers()!=Qt::ControlModifier)
	<%
		jlzpnt=kidlgz->kapni();
		if(hzzqjt.size()==1) hzzqjt[0]->jvsltz();
	%>
%>

qreal jlzpnt(qreal a,qreal b) <% if(a<b) return a; return b; %>
qreal felvnl(qreal a,qreal b) <% if(a<b) return b; return a; %>

void felu::hsztzk()
<%
	QWidget *adelk=viewport();
	QRect vnl=adelk->rect();
	if(kket.size() < 1)
	<%
		scene()->setSceneRect(QRectF(mapToScene(vnl.topLeft()),mapToScene(vnl.bottomRight())));
		return;
	%>

	QRectF bprl;

	qreal x,y,z,t;
	rslt *klsirz=kket.values()[0];

	x=z=klsirz->x() + klsirz->rect().width()/2;
	y=t=klsirz->y() + klsirz->rect().height()/2;

	QList<rslt*> prmz=kket.values();
	foreach(rslt *prl,prmz)
	<%
		if(prl->x() < x) x=prl->x();
		if(prl->y() < y) y=prl->y();
		if(prl->x2() > z) z=prl->x2();
		if(prl->y2() > t) t=prl->y2();
	%>
	x -=100; y -= 100; z+=100,t += 100;

	bprl=QRectF(QPointF(x,y),QPointF(z,t));
        bprl=bprl.united(QRectF(mapToScene(vnl.topLeft()),mapToScene(vnl.bottomRight())));
	if(bprl==sceneRect()) return;
	scene()->setSceneRect(bprl);
%>

void felu::mgmozt()
<%
#if 0
	QRectF klsirz;
	foreach(QGraphicsItem *it,items())
	<%
		klsirz |= it->boundingRect();
	%>
#endif

	fitInView(scene()->sceneRect(),Qt::KeepAspectRatio);
%>

void felu::focusInEvent(QFocusEvent *mgmnkl)
<%
	kltzik();
%>

void felu::kapni()
<%
	kidlgz->hatter(hzzqjt[0]->Id(),((QAction*) QObject::sender())->data().toInt());
%>

#include "Flult.moc"

