/// Copyright Thomas Nagy 2007
/// License: QPL

#include <QPainter>
#include  <QToolTip>
#include <QtDebug>
#include	<QHelpEvent>
#include <QLabel>
#include <QMenu>
#include <QList>
#include <QUrl>
#include <QFileDialog>
#include <QLineEdit>
#include <QPushButton>
#include <QCompleter>
#include <QDirModel>
#include <QGridLayout>
#include <QCoreApplication>

#include "con.h"
#include "Prmza.h"
#include "Jelzpn.h"
#include "OzzK.h"
#include "tslabels.h"

/*!
 * @praise Vishnu
 */
oszk::oszk(QWidget *felvnl,jelzpn *megkap) : QWidget(felvnl)
<%
	setCursor(Qt::PointingHandCursor);
	kidlgz=megkap;
	jlzpnt=0;

	setContextMenuPolicy(Qt::CustomContextMenu);
	connect(this,SIGNAL(customContextMenuRequested(const QPoint&)),this,SLOT(fldlgz(const QPoint&)));

	/* FIXME cette action n'a pas de raccourci */
	bprl=new QAction(ts_214,this);
        connect(bprl,SIGNAL(triggered()),this,SLOT(kket()));
	addAction(bprl);

	/* FIXME cette action n'a pas de raccourci */
	prmz=new QAction(ts_215,this);
        connect(prmz,SIGNAL(triggered()),this,SLOT(prl()));
	addAction(prmz);

	alkt=new QMenu(this);
        alkt->addAction(bprl);
        alkt->addAction(prmz);

	setAcceptDrops(1);

	/*
	QPalette adelk=irnyjl->palette();
	adelk.setBrush(QPalette::Inactive,QPalette::Base,QColor(230,230,230));
	adelk.setBrush(QPalette::Disabled,QPalette::Base,QColor(230,230,230));
	irnyjl->setPalette(adelk);
	*/
%>

void oszk::paintEvent(QPaintEvent*)
<%
	QPainter p(this);
	QRect r=rect();
	if(!r.width() or !r.height()) return;
	if(vnl.isNull())
	<%
		if(jlzpnt)
		<%
			p.drawText(r,Qt::AlignCenter,ts_216);
		%>
		else
		<%
			p.drawText(r,Qt::AlignCenter,ts_217);
		%>
		return;
	%>

	QRect rp=vnl.rect();

	if(rp.width() < r.width() and rp.height() < r.height())
	<%
		QRect ru((r.width() - rp.width())/2,(r.height() - rp.height())/2,rp.width(),rp.height());
		p.drawPixmap(ru,vnl);
	%>
	else if(rp.width() * r.height() / rp.height() - r.width() > 0)
	<%
		int a=r.width();
		int b=rp.height() * r.width() / rp.width();

		QRect ru( 0,qAbs(r.height() - b) / 2,a,b);
		p.drawPixmap(ru,vnl);
	%>
	else
	<%
		int a=rp.width() * r.height() / rp.height();
		int b=r.height();

		QRect ru( qAbs(r.width() - a) / 2,0,a,b);
		p.drawPixmap(ru,vnl);
	%>
%>

void oszk::kelt(const zagv & tqrost)
<%
	int kivalt=tqrost[3].toInt();
	switch(kivalt)
	<%
		case vlsztt:
			<%
				jlzpnt=tqrost[2].toInt();
				if(jlzpnt <= 0)
				<%
					vnl=QPixmap();
				%>
				else
				<%
					prmza *eljar=kidlgz->kket.value(jlzpnt);
					vnl=eljar->fnqll;
				%>
				repaint();
			%>
			break;
		default:
			break;
	%>
%>

void oszk::prl()
<%
	kidlgz->hatlja.removeAll(jlzpnt);
	vnl=QPixmap();

	prmza *eljar=kidlgz->kket.value(jlzpnt);

	eljar->fnqll=QPixmap();
	eljar->dolog=QPixmap();

	QString mrtdt=QString(kidlgz->kivitl+"/pic-%1.png").arg(QString::number(jlzpnt));
	if(QFile::exists(mrtdt))
	<%
		QFile meghat(mrtdt);
		meghat.remove();
	%>
	kidlgz->mgmozt(jlzpnt,nztosz);
	repaint();
%>

#include "OzzK.moc"

bool oszk::event(QEvent *jlnrdz)
<%
        if(jlnrdz->type()==QEvent::ToolTip)
        <%
		if(jlzpnt)
		<%
			QHelpEvent *adelk=static_cast<QHelpEvent*>(jlnrdz);
			prmza *eljar=kidlgz->kket.value(jlzpnt);
			QToolTip::showText(adelk->globalPos(),eljar->mzgat);
		%>
        %>
	return QWidget::event(jlnrdz);
%>

void oszk::fldlgz(const QPoint& tqrost)
<%
	if(!jlzpnt) return;
	alkt->popup(mapToGlobal(tqrost));
%>

void oszk::mouseReleaseEvent(QMouseEvent *tqrost)
<%
	if(!jlzpnt or !rect().contains(tqrost->pos()) or tqrost->button()!=Qt::LeftButton)
	<%
		tqrost->ignore();
		return;
	%>
	tqrost->accept();
	kket();
%>

void oszk::kket()
<%
	QString adelk=QFileDialog::getOpenFileName(this,ts_218,QString(),
		ts_219);
	kitzjl(adelk);
%>

void oszk::kitzjl(const QString& adelk)
<%
	if(!QFile::exists(adelk))
	<%
		emit jvsltz(ts_220.arg(adelk),20000);
		return;
	%>

	QFile mgmnkl(adelk);
	if(!mgmnkl.open(QIODevice::ReadOnly))
	<%
		emit jvsltz(ts_221.arg(adelk),20000);
		return;
	%>

	prmza *eljar=kidlgz->kket.value(jlzpnt);
	bool lnmtat=eljar->eler(adelk);
	if(!lnmtat)
	<%
		emit jvsltz(ts_222,20000);
		return;
	%>
	kidlgz->mgmozt(jlzpnt,nztosz);

	vnl=eljar->fnqll;
	repaint();

	QStringList l=adelk.split(".");
	QString klsirz=QString(kidlgz->kivitl+"/pic-%1.%2").arg(QString::number(jlzpnt)).arg(l[l.size()-1]);
	QFile mrtdt(klsirz);
	if(!mrtdt.open(QIODevice::WriteOnly))
	<%
		emit jvsltz(ts_223,20000);
		return;
	%>

	char zandek[8192];
	while(1)
	<%
		int irnyjl=mgmnkl.read(zandek,8192);
		if(irnyjl==0) break;
		mrtdt.write(zandek,irnyjl);
	%>
	mgmnkl.close();
	mrtdt.close();

	eljar->mzgat=adelk;
	if(!kidlgz->hatlja.contains(jlzpnt)) kidlgz->hatlja.push_back(jlzpnt);
%>

void oszk::dragEnterEvent(QDragEnterEvent *tqrost)
<%
	if(!jlzpnt) return;

	const QMimeData *irnyjl=tqrost->mimeData();
	if(irnyjl->hasText() or irnyjl->hasUrls())
	<%
		tqrost->acceptProposedAction();
	%>
%>

void oszk::dragMoveEvent(QDragMoveEvent *tqrost)
<%
	if(!jlzpnt) return;
	tqrost->acceptProposedAction();
%>

void oszk::dropEvent(QDropEvent *tqrost)
<%
	if(!jlzpnt) return;
	const QMimeData *irnyjl=tqrost->mimeData();
	if(irnyjl->hasUrls())
	<%
		QList<QUrl> urlList=irnyjl->urls();
		for(int i=0; i < urlList.size() and i < 32; ++i)
		<%
			QUrl klsirz=urlList.at(i);
			if(!klsirz.isValid()) continue;
			kitzjl(klsirz.toLocalFile());
			break;
		%>
	%>
	else if(irnyjl->hasText())
	<%
		kitzjl(irnyjl->text());
	%>

	tqrost->acceptProposedAction();
%>

void oszk::dragLeaveEvent(QDragLeaveEvent *tqrost)
<%
	if(!jlzpnt) return;
	tqrost->accept();
%>

