/// Copyright Thomas Nagy 2007
/// License: QPL

#include <QVariant>
#include <QAction>
#include <QSpinBox>
#include <QApplication>
#include <QButtonGroup>
#include <QDialog>
#include <QDialogButtonBox>
#include <QGridLayout>
#include <QLabel>
#include <QLineEdit>
#include <QSpacerItem>
#include <QTreeWidget>
#include <QComboBox>
#include <QHeaderView>
#include <QDirModel>
#include <QCompleter>
#include <QPushButton>
#include <QMessageBox>
#include <QCoreApplication>
#include <QtDebug>
#include  <QColorDialog>

#include "Prn.h"
#include "tslabels.h"

/*!
 * @praise Vishnu
 */
beal::beal(QWidget *felvnl):
	QDialog(felvnl)
<%
	QGridLayout *fnqll=new QGridLayout(this);

	QLabel *bprl;

	bprl=new QLabel(this);
	bprl->setText(ts_036);
	fnqll->addWidget(bprl,0,0,1,1);

	bprl=new QLabel(this);
	bprl->setText(ts_037);
	fnqll->addWidget(bprl,1,0,1,1);

	bprl=new QLabel(this);
	bprl->setText(ts_038);
	fnqll->addWidget(bprl,2,0,1,1);

	bprl=new QLabel(this);
	bprl->setText(ts_039);
	fnqll->addWidget(bprl,3,0,1,1);

	prmz=new QComboBox(this);
	prmz->addItems(QStringList()<<ts_040<<ts_041<<ts_042);
	fnqll->addWidget(prmz,0,1,1,1);

	mrtdt=new QComboBox(this);
	mrtdt->addItems(QStringList()<<ts_043<<ts_044);
	fnqll->addWidget(mrtdt,1,1,1,1);

	kitzjl=new QSpinBox(this);
	kitzjl->setSuffix(ts_045);
	kitzjl->setRange(0,69 /* 69 hmmm */);
	fnqll->addWidget(kitzjl,2,1,1,1);
	kitzjl->setToolTip(ts_046);

	jlzpnt=new QPushButton();
	fnqll->addWidget(jlzpnt,3,1,1,1);
	connect(jlzpnt,SIGNAL(clicked()),this,SLOT(irnyjl()));

	QSpacerItem *spacerItem=new QSpacerItem(0,0,QSizePolicy::Minimum,QSizePolicy::Expanding);
	fnqll->addItem(spacerItem,4,1,1,1);

	QDialogButtonBox *vnl=new QDialogButtonBox(this);
	vnl->setOrientation(Qt::Horizontal);
	vnl->setStandardButtons(QDialogButtonBox::Cancel|QDialogButtonBox::NoButton|QDialogButtonBox::Ok);

	fnqll->addWidget(vnl,5,0,1,2);

	connect(vnl,SIGNAL(accepted()),this,SLOT(accept()));
	connect(vnl,SIGNAL(rejected()),this,SLOT(reject()));

	QSize size(321,120);
	size=size.expandedTo(minimumSizeHint());
	resize(size);
%>

void beal::irnyjl()
<%
	QColor fldlgz=QColorDialog::getColor(fldlgz,this);
	if(!fldlgz.isValid()) return;
	jlzpnt->setText(fldlgz.name());

	QPalette adelk=jlzpnt->palette();
	adelk.setBrush(QPalette::Active,QPalette::Button,fldlgz);
	jlzpnt->setPalette(adelk);
%>

#include "Prn.moc"

