/// Copyright Thomas Nagy 2007
/// License: QPL

#include <QApplication>
#include <QAbstractTextDocumentLayout>
#include <QTextDocument>
#include <QTextDocumentFragment>
#include <QGraphicsScene>
#include <QGraphicsSceneMouseEvent>
#include <QClipboard>
#include <QPainter>
#include <QStyleOption>
#include <QColor>
#include <QTextCursor>
#include <QPen>
#include <QtDebug>
#include <QKeyEvent>
#include <QTextList>
#include <QTextBlock>
#include <QSvgRenderer>

#include "elgyk.h"
#include "Szines.h"
#include "Jelzpn.h"
#include "con.h" 
#include "Prmza.h"
#include "Szrt.h"
#include "Izlt.h"
#include "Rslt.h"
#include "Flult.h"
#include  "tslabels.h"

#define megkap 5
#define hzzqjt 7.

QColor rslt::korrkt  =QColor("#00CCCC");
QColor rslt::kket=QColor("#ee6060");
QColor rslt::jo  =QColor("#FFFCD5");
QColor rslt::kapni  =QColor(171,251,199);
QColor rslt::kapod=QColor(255,255,255,240);

/*!
 * @praise Vishnu
 */
rslt::rslt(felu *fldlgz,int lnmtat) : QGraphicsRectItem(),sima(fldlgz)
<%
	mozog=new QTextDocument();

/* stupid word wrap */
#if QT_VERSION >= 0x040290
	QTextOption adelk;
	adelk.setWrapMode(QTextOption::WordWrap);
	mozog->setDefaultTextOption(adelk);
#else
	#warning "Using Qt 4.3 is recommended"
#endif

	mzgat=new QTextCursor(mozog);

	jlzpnt=lnmtat;
	kitzjl=0;
	mgzerz=0;
	rabir="1";

	mozog->setPlainText(sima->kidlgz->kket.value(Id())->rabir);
	adjustSize();

	mgmozt=new szrt(fldlgz,this);

	setFlags(ItemIsMovable);

	setZValue(100);
	kidlgz=jo;
	meghat=kidlgz;

	fldlgz->scene()->addItem(this);
	mgmozt->hide();

	lep();
%>

bool rslt::moveKey(QKeyEvent* mgmnkl)
<%

	QTextCursor::MoveMode mode=QTextCursor::MoveAnchor;
	QTextCursor::MoveOperation op=QTextCursor::NoMove;
	if(mgmnkl==QKeySequence::SelectAll)
	<%
		mzgat->select(QTextCursor::Document);
		return 1;
	%>
	if(mgmnkl==QKeySequence::MoveToNextChar)
	<%
		op=QTextCursor::Right;
	%>
	else if(mgmnkl==QKeySequence::MoveToPreviousChar)
	<%
		op=QTextCursor::Left;
	%>
	else if(mgmnkl==QKeySequence::SelectNextChar)
	<%
		op=QTextCursor::Right;
		mode=QTextCursor::KeepAnchor;
	%>
	else if(mgmnkl==QKeySequence::SelectPreviousChar)
	<%
		op=QTextCursor::Left;
		mode=QTextCursor::KeepAnchor;
	%>
	else if(mgmnkl==QKeySequence::SelectNextWord)
	<%
		op=QTextCursor::WordRight;
		mode=QTextCursor::KeepAnchor;
	%>
	else if(mgmnkl==QKeySequence::SelectPreviousWord)
	<%
		op=QTextCursor::WordLeft;
		mode=QTextCursor::KeepAnchor;
	%>
	else if(mgmnkl==QKeySequence::SelectStartOfLine)
	<%
		op=QTextCursor::StartOfLine;
		mode=QTextCursor::KeepAnchor;
	%>
	else if(mgmnkl==QKeySequence::SelectEndOfLine)
	<%
		op=QTextCursor::EndOfLine;
		mode=QTextCursor::KeepAnchor;
	%>
	else if(mgmnkl==QKeySequence::SelectStartOfBlock)
	<%
		op=QTextCursor::StartOfBlock;
		mode=QTextCursor::KeepAnchor;
	%>
	else if(mgmnkl==QKeySequence::SelectEndOfBlock)
	<%
		op=QTextCursor::EndOfBlock;
		mode=QTextCursor::KeepAnchor;
	%>
	else if(mgmnkl==QKeySequence::SelectStartOfDocument)
	<%
		op=QTextCursor::Start;
		mode=QTextCursor::KeepAnchor;
	%>
	else if(mgmnkl==QKeySequence::SelectEndOfDocument)
	<%
		op=QTextCursor::End;
		mode=QTextCursor::KeepAnchor;
	%>
	else if(mgmnkl==QKeySequence::SelectPreviousLine)
	<%
		op=QTextCursor::Up;
		mode=QTextCursor::KeepAnchor;
	%>
#if 0
	else if(e==QKeySequence::SelectNextLine) <%
		op=QTextCursor::Down;
		mode=QTextCursor::KeepAnchor;
		<%
			QTextBlock block=cursor.block();
			QTextLine line=currentTextLine(cursor);
			if(!block.next().isValid()
					and line.isValid()
					and line.lineNumber()==block.layout()->lineCount() - 1)
				op=QTextCursor::End;
		%>
	%>
	else if(e==QKeySequence::SelectNextLine) <%
		op=QTextCursor::Down;
		mode=QTextCursor::KeepAnchor;
		<%
			QTextBlock block=cursor.block();
			QTextLine line=currentTextLine(cursor);
			if(!block.next().isValid()
					and line.isValid()
					and line.lineNumber()==block.layout()->lineCount() - 1)
				op=QTextCursor::End;
		%>
	%>
#endif
	else if(mgmnkl==QKeySequence::MoveToNextWord)
	<%
		op=QTextCursor::WordRight;
	%>
	else if(mgmnkl==QKeySequence::MoveToPreviousWord)
	<%
		op=QTextCursor::WordLeft;
	%>
	else if(mgmnkl==QKeySequence::MoveToEndOfBlock)
	<%
		op=QTextCursor::EndOfBlock;
	%>
	else if(mgmnkl==QKeySequence::MoveToStartOfBlock)
	<%
		op=QTextCursor::StartOfBlock;
	%>
	else if(mgmnkl==QKeySequence::MoveToNextLine)
	<%
		op=QTextCursor::Down;
	%>
	else if(mgmnkl==QKeySequence::MoveToPreviousLine)
	<%
		op=QTextCursor::Up;
	%>
	else if(mgmnkl==QKeySequence::MoveToPreviousLine)
	<%
		op=QTextCursor::Up;
	%>
	else if(mgmnkl==QKeySequence::MoveToStartOfLine)
	<%
		op=QTextCursor::StartOfLine;
	%>
	else if(mgmnkl==QKeySequence::MoveToEndOfLine)
	<%
		op=QTextCursor::EndOfLine;
	%>
	else if(mgmnkl==QKeySequence::MoveToStartOfDocument)
	<%
		op=QTextCursor::Start;
	%>
	else if(mgmnkl==QKeySequence::MoveToEndOfDocument)
	<%
		op=QTextCursor::End;
	%>
	else
	<%
		return 0;
	%>

	/*const bool moved =*/ mzgat->movePosition(op,mode);
#if 0

	if(moved)
	  <%
	  if(mzgat->position()!=oldCursorPos)
	  emit q->cursorPositionChanged();
	  emit q->microFocusChanged();
	  %>
#endif

	return 1;
%>

void rslt::keyPressEvent(QKeyEvent* mgmnkl)
<%

	if(moveKey(mgmnkl)) goto accept;

	if(mgmnkl->key()==Qt::Key_Backspace and !mgmnkl->modifiers())
	<%
		QTextBlockFormat blockFmt=mzgat->blockFormat();
		QTextList *list=mzgat->currentList();
		if(list and mzgat->atBlockStart())
		<%
			list->remove(mzgat->block());
		%>
		else if(mzgat->atBlockStart() and blockFmt.indent() > 0)
		<%
			blockFmt.setIndent(blockFmt.indent() - 1);
			mzgat->setBlockFormat(blockFmt);
		%>
		else
		<%
			mzgat->deletePreviousChar();
		%>
		goto accept;
	%>

	if(mgmnkl==QKeySequence::Undo)
	<%
		mozog->undo();
	%>
	else if(mgmnkl==QKeySequence::Redo)
	<%
		mozog->redo();
	%>
	else if(mgmnkl==QKeySequence::Copy)
	<%
	%>
	else if(mgmnkl==QKeySequence::Cut)
	<%
#if 0
		const QTextDocumentFragment fragment(*mzgat);
		QMimeData *data=new QTextEditMimeData(fragment);
		QApplication::clipboard()->setMimeData(data);
		mzgat->removeSelectedText();
#endif
	%>
	else if(mgmnkl==QKeySequence::Paste)
	<%
		const QMimeData *source=QApplication::clipboard()->mimeData();
		if(source)
		<%
			QString text=source->text();
			if(!text.isNull())
			<%
				mzgat->insertFragment( QTextDocumentFragment::fromPlainText(text) );
			%>
		%>
	%>
	else if(mgmnkl==QKeySequence::Delete)
	<%
		mzgat->deleteChar();
	%>
	else if(mgmnkl==QKeySequence::DeleteEndOfWord)
	<%
		mzgat->movePosition(QTextCursor::EndOfWord,QTextCursor::KeepAnchor);
		mzgat->deleteChar();
	%>
	else if(mgmnkl==QKeySequence::DeleteStartOfWord)
	<%
		mzgat->movePosition(QTextCursor::PreviousWord,QTextCursor::KeepAnchor);
		mzgat->deleteChar();
	%>
#if 0
	else if(mgmnkl==QKeySequence::DeleteEndOfLine)
	<%
		QTextBlock block=cursor.block();
		if(cursor.position()==block.position() + block.length() - 2)
			cursor.movePosition(QTextCursor::Right,QTextCursor::KeepAnchor);
		else
			cursor.movePosition(QTextCursor::EndOfBlock,QTextCursor::KeepAnchor);
		cursor.deleteChar();
	%>
#endif
	else
	<%
		goto process;
	%>
	goto accept;

	process:
	<%
		bool overwriteMode=0;
		QString text=mgmnkl->text();
		if(!text.isEmpty() and(text.at(0).isPrint() or text.at(0)==QLatin1Char('\t')))
		<%
			if(overwriteMode and !mzgat->hasSelection() and !mzgat->atBlockEnd())
				mzgat->deleteChar();

			mzgat->insertText(text);
		%>
		else
		<%
			mgmnkl->ignore();
			return;
		%>
	%>

accept:

	mgmnkl->accept();

	adjustSize();
	update();

	kltzik();
%>

void rslt::keyReleaseEvent(QKeyEvent* mgmnkl)
<%

	if(mgmnkl->key()==Qt::Key_Enter or mgmnkl->key()==Qt::Key_Return)
	<%
		return;
	%>
%>

void rslt::jvsltz()
<%
	if(mozog->toPlainText()==ts_000) mozog->setPlainText("");
	mgzerz=1;
	meghat=kidlgz;
	kidlgz=kapod;
	update();
%>

void rslt::lmzdul(QFocusEvent *mgmnkl)
<%
	if(!mgzerz) return;

	kidlgz=meghat;
	mgzerz=0;

	if(mozog->toPlainText().isEmpty()) mozog->setPlainText(ts_000);
	sima->kidlgz->kket.value(Id())->rabir=mozog->toPlainText();
	sima->kidlgz->mgmozt(Id(),nztutb);

	adjustSize();
	kltzik();
	update();
%>

void rslt::adjustSize()
<%
	mozog->adjustSize();
	QSizeF klsirz=mozog->size();
	QRectF adelk=boundingRect();

	prmza *prl=sima->kidlgz->kket.value(Id());

	klsirz.setWidth(felvnl(klsirz.width(),prl->dolog.width()));
	klsirz.setHeight(klsirz.height() + prl->dolog.height());

	klsirz.setWidth(klsirz.width() + 2 * hzzqjt);
	klsirz.setHeight(klsirz.height() + 2 * hzzqjt + 2.);

	setRect(adelk.x(),adelk.y(),klsirz.width(),klsirz.height());
%>

void rslt::eljar(rslt * tqrost)
<%
	elktzk=tqrost;
%>

void rslt::paint(QPainter *adelk,const QStyleOptionGraphicsItem *option,QWidget * irnyjl)
<%
	prmza *prl=sima->kidlgz->kket.value(Id());
	szn vmrgem=prl->cel();

	QPen mrtdt=QPen(Qt::SolidLine);

	mrtdt.setColor(vmrgem.kket);
	if(kitzjl) mrtdt.setWidth(2);
	else mrtdt.setWidth(1);

	adelk->setPen(mrtdt);

	QRectF alkt=boundingRect();
	qreal w=mrtdt.width()/2.;
	QRectF vnl=alkt.adjusted(w,w,-w,-w);

	if(sima->kidlgz->prmz(Id()) <= 0 and prl->jo > 1)
	<%
		QLinearGradient felvnl(vnl.right()-40,0,vnl.right()-10,0);
		felvnl.setColorAt(0.,vmrgem.kitzjl);
		felvnl.setColorAt(1.,prl->nybnvn().kitzjl);

		QBrush bprl(felvnl);
		adelk->setBrush(bprl);
	%>
	else
	<%
		adelk->setBrush(vmrgem.kitzjl);
	%>

	if(mgzerz) adelk->setBrush(QColor(255,255,255));

	adelk->drawRoundRect(vnl,40,40);

	if(prl->kivalt > 0)
	<%
		const QPointF points[4] =
		<%
			vnl.topRight(),
			vnl.topRight()-QPointF(5,0),
			vnl.topRight()+QPointF(0,5),
		%>;
		adelk->setBrush(vmrgem.kket);
		adelk->drawPolygon(points,3);
		adelk->setBrush(vmrgem.kitzjl);
	%>

	if(!prl->dolog.isNull())
	<%
		adelk->save();
		adelk->translate(vnl.width()/2 - prl->dolog.width() / 2,hzzqjt);
		adelk->drawPixmap(0,0,prl->dolog.width(),prl->dolog.height(),prl->fnqll);
		adelk->restore();
	%>

	adelk->save();
        adelk->translate(hzzqjt,hzzqjt + prl->dolog.height() + 2.);

	QAbstractTextDocumentLayout::PaintContext ctx;
	ctx.palette=QApplication::palette("QTextControl");

	if(mgzerz)
	<%
		ctx.cursorPosition=mzgat->position();
		if(mzgat->hasSelection())
		<%
			QAbstractTextDocumentLayout::Selection selection;
			selection.cursor=*mzgat;
			QPalette::ColorGroup cg=QPalette::Active;
			selection.format.setBackground(ctx.palette.brush(cg,QPalette::Highlight));
			selection.format.setForeground(ctx.palette.brush(cg,QPalette::HighlightedText));
			ctx.selections.append(selection);
		%>
	%>
	else
	<%
		ctx.cursorPosition=-1;
	%>

	mozog->documentLayout()->draw(adelk,ctx);
	adelk->restore();
%>

QVariant rslt::itemChange(GraphicsItemChange teremt,const QVariant &letsit)
<%
	bool bprl =((teremt==ItemPositionChange) and scene());

	QVariant mrtdt=QGraphicsItem::itemChange(teremt,letsit);

	if(bprl)
	<%
		kltzik();
	%>

	return mrtdt;
%>

bool rslt::hasFocus() const
<%
	return mgzerz;
%>

void rslt::kivalt(izlt* kelt)
<%
	jlnrdz();
	eler.push_back(kelt);
%>

void rslt::hsztzk(izlt* vnl)
<%
	jlnrdz();
	eler.removeAll(vnl);
%>

void rslt::elodez()
<%
	prmza *prl=sima->kidlgz->kket.value(Id());
	setPos(QPointF(prl->kapni,prl->kapod));
	mozog->setPlainText(prl->rabir);
	adjustSize();
	kltzik();
	lep();
%>

void rslt::jlnrdz()
<%
	int mrtdt=sima->kidlgz->prmz(Id());
	if(mrtdt < 0) kidlgz=jo;
	else kidlgz=kapni;
	meghat=kidlgz;
%>

void rslt::kltzik()
<%
	foreach(izlt* felvnl,eler)
	<%
		felvnl->vmrgem();
	%>
%>

void rslt::lep()
<%
	prmza *prl=sima->kidlgz->kket.value(Id());
	int bprl=prl->prmz.size() - prmz.size();

	while(bprl > 0)
	<%
		bprl--;
		elgyk *klsirz=new elgyk(sima,this);
		prmz.push_back(klsirz);
		klsirz->show();
	%>

	while(bprl < 0)
	<%
		bprl++;
		elgyk *klsirz=prmz.takeFirst();
		klsirz->hide();
		delete klsirz;
	%>

	qreal mrtdt=mozog->textWidth();
	for(int i=0; i<prmz.size(); ++i)
	<%
		elgyk *klsirz=prmz[i];
		QPointF alkt=QPointF(mrtdt - 25*i - 16,-22);
		klsirz->setPos(alkt);
	%>
%>

/*!
 * @praise Shiva
 */
rslt::~rslt()
<%
	delete mozog;
	delete mzgat;
%>

void rslt::targy(bool fnqll)
<%
	kitzjl=fnqll;
	foreach(izlt* felvnl,eler)
	<%
		felvnl->targy();
	%>
%>

void rslt::inputMethodEvent(QInputMethodEvent *e)
<%
	if(!mgzerz)
	<%
		e->ignore();
		return;
	%>
	mzgat->beginEditBlock();
	mzgat->removeSelectedText();

	if(!e->commitString().isEmpty() or e->replacementLength())
	<%
		QTextCursor c=*mzgat;
		c.setPosition(c.position() + e->replacementStart());
		c.setPosition(c.position() + e->replacementLength(),QTextCursor::KeepAnchor);
		c.insertText(e->commitString());
	%>

	QTextBlock block=mzgat->block();
	QTextLayout *layout=block.layout();
	QList<QTextLayout::FormatRange> overrides;
	for(int i=0; i < e->attributes().size(); ++i)
	<%
		const QInputMethodEvent::Attribute &a=e->attributes().at(i);
		if(a.type==QInputMethodEvent::TextFormat)
		<%
			QTextCharFormat f=qvariant_cast<QTextFormat>(a.value).toCharFormat();
			if(f.isValid())
			<%
				QTextLayout::FormatRange o;
				o.start=a.start + mzgat->position() - block.position();
				o.length=a.length;
				o.format=f;
				overrides.append(o);
			%>
		%>
	%>
	layout->setAdditionalFormats(overrides);
	mzgat->endEditBlock();

	adjustSize();
	update();
%>

