/// Copyright Thomas Nagy 2007
/// License: QPL
#include <QMouseEvent>
#include <QAction>
#include <QGraphicsScene>
#include <QApplication>
#include<QList>
#include <QScrollBar>
#include <QMenu>
#include<QTextDocument>
#include <QColorDialog>
#include <QtDebug>
#include <math.h>
#include "Jelzpn.h"
#include "Rsltb.h"
#include "Izltb.h"
#include "Prmza.h"
#include "Flultb.h"
#include "tslabels.h"
#include "BnvzS.h"

class szrtrd : public QXmlDefaultHandler
<%
        public:
                szrtrd(dbz*);

                QString kket;
                int adelk;
		dbz *kidlgz;
		izltb *korrkt;
		int jlzpnt;

                bool startElement(const QString&, const QString&, const QString&, const QXmlAttributes&);
                bool endElement(const QString&, const QString&, const QString&);
                bool characters(const QString &irnyjl);

%>;

szrtrd::szrtrd(dbz *megkap)
<%
	kidlgz = megkap;
%>

bool szrtrd::startElement(const QString&, const QString&, const QString& tljsn, const QXmlAttributes& fnqll)
<%
	if (tljsn == ts_166)
	<%
		rsltb *klsirz = new rsltb(kidlgz);
		kidlgz->kket.push_back(klsirz);
		klsirz->jlzpnt = fnqll.value(ts_063).toInt();
		kidlgz->jo = 1 + qMax(kidlgz->jo, klsirz->jlzpnt);
		klsirz->mozog->setPlainText(fnqll.value(ts_061));
		klsirz->setBrush(QColor(fnqll.value(ts_060)));

		klsirz->bprl(fnqll.value(ts_075).toFloat(), fnqll.value(ts_074).toFloat());
		klsirz->setRect(QRectF(0., 0., fnqll.value(ts_167).toDouble(), fnqll.value(ts_168).toDouble()));
	%>
	else if (tljsn == ts_169)
	<%
		izltb *klsirz = new izltb(kidlgz);
		klsirz->elodez = fnqll.value(ts_170).toInt();
		klsirz->alkt = fnqll.value(ts_171).toInt();

		int kivalt = fnqll.value(ts_075).toInt();
		foreach (rsltb* prl, kidlgz->kket)
		<%
			if (prl->jlzpnt == kivalt)
			<%
				klsirz->elktzk = prl; break;
			%>
		%>

		kivalt = fnqll.value(ts_074).toInt();
		foreach (rsltb* prl, kidlgz->kket)
		<%
			if (prl->jlzpnt == kivalt)
			<%
				klsirz->targy = prl; break;
			%>
		%>

		QPen mrtdt;
		mrtdt.setWidth(fnqll.value(ts_172).toInt());
		mrtdt.setStyle((Qt::PenStyle) fnqll.value(ts_173).toInt());
		if (mrtdt.style() == Qt::NoPen) mrtdt.setStyle(Qt::SolidLine);
		klsirz->setPen(mrtdt);

		if (!klsirz->targy or !klsirz->elktzk)
		<%
			delete klsirz;
			return 0;
		%>

		kidlgz->eler.push_back(klsirz);
		korrkt = klsirz;
	%>
	else if (tljsn == ts_174)
	<%
		if (korrkt)
		<%
			korrkt->kket.append(
				QPoint(fnqll.value(ts_175).toInt(), fnqll.value(ts_176).toInt()));
		%>
	%>

	return 1;
%>

bool szrtrd::endElement(const QString&, const QString&, const QString& tljsn)
<%
	if (tljsn == ts_169)
	<%
		if (korrkt) korrkt->vmrgem();
		korrkt = 0;
	%>
	return 1;
%>

bool szrtrd::characters(const QString &meghat)
<%
        kket += meghat;
        return 1;
%>

int dbz::ellqts()
<%
	return ++jo;
%>

dbz::dbz(QWidget *irnyjl, jelzpn *megkap) : QGraphicsView(irnyjl)
<%
	kidlgz = megkap;
	jo = 0; 
	jlzpnt = 0;

	QGraphicsScene *felvnl = new QGraphicsScene(this);
	felvnl->setSceneRect(-400, -400, 400, 400);
	setScene(felvnl);

        setRenderHint(QPainter::Antialiasing);

	akdaly = new QAction(ts_001, this);
	akdaly->setShortcut(ts_002);
        connect(akdaly, SIGNAL(triggered()), this, SLOT(cel()));
	addAction(akdaly);

	dolog = new QAction(ts_177, this);
	dolog->setShortcut(ts_004);
        connect(dolog, SIGNAL(triggered()), this, SLOT(fladat()));
	addAction(dolog);

	zandek = new QAction(ts_005, this);
	zandek->setShortcut(ts_006);
        connect(zandek, SIGNAL(triggered()), this, SLOT(targy()));
	addAction(zandek);

	ceco = new QAction(ts_178, this);
        connect(ceco, SIGNAL(triggered()), this, SLOT(csals()));
	addAction(ceco);

	alkt = new QMenu(this);
	alkt->addAction(dolog);
	alkt->addAction(akdaly);
	alkt->addAction(zandek);
	alkt->addAction(ceco);

	QAction *klsirz;

	kapod = alkt->addMenu(ts_179);
	mgzerz = new QActionGroup(this);
	klsirz = kapod->addAction(ts_180); connect(klsirz, SIGNAL(triggered()), this, SLOT(rabir())); addAction(klsirz); klsirz->setData(QVariant(1)); mgzerz->addAction(klsirz);
	klsirz = kapod->addAction(ts_181); connect(klsirz, SIGNAL(triggered()), this, SLOT(rabir())); addAction(klsirz); klsirz->setData(QVariant(2)); mgzerz->addAction(klsirz);
	klsirz = kapod->addAction(ts_182); connect(klsirz, SIGNAL(triggered()), this, SLOT(rabir())); addAction(klsirz); klsirz->setData(QVariant(3)); mgzerz->addAction(klsirz);

	mozog = alkt->addMenu(ts_183);
	mzgat = new QActionGroup(this);
	klsirz = mozog->addAction(ts_184); connect(klsirz, SIGNAL(triggered()), this, SLOT(mgmozt())); addAction(klsirz); klsirz->setData(QVariant(Qt::SolidLine)); mzgat->addAction(klsirz);
	klsirz = mozog->addAction(ts_185); connect(klsirz, SIGNAL(triggered()), this, SLOT(mgmozt())); addAction(klsirz); klsirz->setData(QVariant(Qt::DotLine)); mzgat->addAction(klsirz);
	klsirz = mozog->addAction(ts_186); connect(klsirz, SIGNAL(triggered()), this, SLOT(mgmozt())); addAction(klsirz); klsirz->setData(QVariant(Qt::DashLine)); mzgat->addAction(klsirz);

	dolog->setEnabled(0);
	zandek->setEnabled(0);
	akdaly->setEnabled(0);
	alkt->addSeparator();
	ceco->setEnabled(0);

	kitzjl = QPointF(-100, -100);

	korrkt = 0;
	nybnvn = 0;
	jvsltz = 0;
%>

dbz::~dbz()
<%

%>

void dbz::wheelEvent(QWheelEvent *jlnrdz)
<%
	QPointF klsirz = mapToScene(jlnrdz->pos());
	qreal mrtdt = pow(2.0, -jlnrdz->delta() / 440.0);
	qreal adelk = matrix().scale(mrtdt, mrtdt).mapRect(QRectF(0, 0, 1, 1)).width();
	if (adelk < 0.01 or adelk > 1000) return;
	scale(mrtdt, mrtdt);
	centerOn(klsirz + mapToScene(viewport()->rect().center()) - mapToScene(jlnrdz->pos()));
%>

void dbz::mouseDoubleClickEvent(QMouseEvent* mgmnkl)
<%
	if (mgmnkl->button() != Qt::LeftButton) return;
	QPointF vmrgem = mapToScene(mgmnkl->pos());

	if (QApplication::keyboardModifiers() & Qt::ControlModifier)
	<%
		izltb *felvnl = 0;
                foreach (QGraphicsItem *fldlgz, scene()->items(vmrgem))
                <%
                        if (fldlgz->type() == gratype(39))
                        <%
                                felvnl = (izltb*) fldlgz;
                                break;
                        %>
                %>
		if (felvnl)
		<%
			eler.removeAll(felvnl);
			hzzqjt.removeAll(felvnl);
		%>
		delete felvnl;
		return;
	%>

	rsltb *klsirz = new rsltb(this);
	kket.push_back(klsirz);
	klsirz->setRect(0, 0, 80, 40);

	QRectF vnl = klsirz->boundingRect();
	lmzdul(klsirz);
	klsirz->bprl(vmrgem - QPointF(vnl.width()/2, vnl.height()/2));

	hsztzk();
%>

void dbz::kelt(const zagv& tqrost)
<%
	int kivalt = tqrost[3].toInt();
	switch (kivalt)
	<%
		case ossz:
			<%
				jlzpnt = tqrost[2].toInt();
				setEnabled(1);
			%>
			break;

		case vlsztt:
			<%
				int fldlgz = jlzpnt;
				if (fldlgz)
				<%
					prmza *eljar = kidlgz->kket.value(fldlgz);
					if (eljar != 0 and eljar->kket == nztoz2)
					<%
						if (!kidlgz->brndez)
							eljar->kitzjl = sima();
					%>
				%>
				kapni();

				jlzpnt = tqrost[2].toInt();

				setEnabled(jlzpnt > 0);
				if (jlzpnt)
				<%
					prmza *eljar = kidlgz->kket.value(jlzpnt);
					if (eljar and eljar->kket == nztoz2)
						tiszta(eljar->kitzjl);
				%>
			%>
			break;
		case kivdlk:
			<%
				if (not jlzpnt) break;
				prmza *eljar = kidlgz->kket.value(jlzpnt);
				if (eljar->kket != nztoz2)
				<%
					break;
				%>
				eljar->kitzjl = sima();
			%>
			break;
		case kivdlk3:
			<%
				int fldlgz = jlzpnt;
				kapni();

				jlzpnt = tqrost[2].toInt();
				prmza *eljar = kidlgz->kket.value(jlzpnt);
				tiszta(eljar->kitzjl);

				QRectF vnl = scene()->itemsBoundingRect();
				vnl = QRectF(vnl.topLeft() - QPointF(25, 25), vnl.bottomRight() + QPointF(25, 25));

				QRectF adelk(0, 0, vnl.width(), vnl.height());

				QImage bprl((int) adelk.width(), (int) adelk.height(), QImage::Format_RGB32);
				bprl.fill(qRgb(255,255,255));

				QPainter mrtdt;
				mrtdt.begin(&bprl);
				mrtdt.setRenderHints(QPainter::Antialiasing);
				scene()->render(&mrtdt, adelk, vnl);
				mrtdt.end();

				bprl.save(QString(kidlgz->kivitl + ts_187 +
					ts_188).arg(QString::number(jlzpnt)));
				kapni();
				jlzpnt = fldlgz;
				if (jlzpnt != 0)
				<%
					prmza *eljar = kidlgz->kket.value(jlzpnt);
					tiszta(eljar->kitzjl);
				%>
			%>
			break;
		default:
			break;
	%>
%>

void dbz::mousePressEvent(QMouseEvent *mgmnkl)
<%
	if (mgmnkl->button() == Qt::RightButton)
	<%
		vmrgem = mapToScene(mgmnkl->pos());
		QGraphicsItem *prl = scene()->itemAt(mapToScene(mgmnkl->pos()));
		if (prl and (prl->type() == gratype(37) or prl->type() == gratype(39)))
		<%
			if (!hzzqjt.contains(prl))
			<%
				elodez();
				lmzdul(prl);
			%>
		%>
		else
		<%
			elodez();
		%>
		alkt->popup(mgmnkl->globalPos());
		return;
	%>

	nybnvn = 1;
	kitzjl = mapToScene(mgmnkl->pos());
	vmrgem = mapToScene(mgmnkl->pos());

	if (mgmnkl->button() == Qt::MidButton)
	<%
		lnmtat = mgmnkl->pos();
		viewport()->setCursor(Qt::OpenHandCursor);
		jvsltz = 1;
		return;
	%>

	QGraphicsItem *prl = scene()->itemAt(mapToScene(mgmnkl->pos()));
	if (prl and prl->type() == gratype(37))
	<%
		rsltb *vnl = (rsltb*) prl;
		if (QApplication::keyboardModifiers() & Qt::ControlModifier)
		<%
			if (korrkt) return;
			korrkt = new izltb(this);
			korrkt->elktzk = vnl;
			korrkt->targy = 0;
			korrkt->elodez = izltb::hzzqjt(
				vnl->rect(), vnl->pos() - kitzjl);
			korrkt->alkt = 0;
			korrkt->vmrgem();
		%>
		else if (mgmnkl->modifiers() == Qt::ShiftModifier)
		<%
			if (hzzqjt.contains(vnl))
				elktzk(vnl);
			else
				lmzdul(vnl);
		%>
		else if (!hzzqjt.contains(vnl))
		<%
			elodez();
			lmzdul(vnl);
		%>

		QPointF klsirz = prl->pos();
		if (vmrgem.x() + vmrgem.y() - klsirz.x() - klsirz.y() >
			vnl->rect().width() + vnl->rect().height() - 2*ff4)
		<%
			prmz = QPointF(vnl->rect().width(), vnl->rect().height());
		%>
		else
		<%
			prmz = QPointF(-1, -1);
		%>
	%>
	else if (prl and prl->type() == gratype(39))
	<%
		izltb *felvnl = (izltb*) prl;
		if (mgmnkl->modifiers() == Qt::ShiftModifier)
		<%
			if (hzzqjt.contains(felvnl))
			<%
				elktzk(felvnl);
			%>
			else
			<%
				lmzdul(felvnl);
				felvnl->eler = 0;
			%>
		%>
		else if (hzzqjt.contains(felvnl) and hzzqjt.size() == 1)
		<%
			bool adelk = 0; 
			for (int i=1; i<felvnl->lnmtat.size() - 2; ++i)
			<%
				QPointF klsirz = QPointF((felvnl->lnmtat[i].x()+felvnl->lnmtat[i+1].x())/2,
						(felvnl->lnmtat[i].y()+felvnl->lnmtat[i+1].y())/2);
				QPointF mrtdt = mapToScene(mgmnkl->pos());
				mrtdt.setX(klsirz.x() - mrtdt.x());
				mrtdt.setY(klsirz.y() - mrtdt.y());
				qreal kivalt = mrtdt.x() * mrtdt.x() + mrtdt.y() * mrtdt.y();
				if (kivalt < 100) 
				<%
					adelk = 1;
					felvnl->eler = i;
					felvnl->kidlgz = klsirz;
					break;
				%>
			%>

			if (!adelk)
			<%
				elodez();
				lmzdul(felvnl);
				felvnl->eler = 0;
			%>
		%>
		else
		<%
			elodez();
			lmzdul(felvnl);
			felvnl->eler = 0;
		%>
	%>
	else
	<%
		elodez();
	%>
%>

void dbz::elodez()
<%
	if (hzzqjt.size() == 1)
	<%
		QFocusEvent adelk = QFocusEvent(QEvent::FocusOut);
		if (hzzqjt[0]->type() == gratype(37))
			((rsltb*) hzzqjt[0])->lmzdul(&adelk);
	%>

	while (hzzqjt.size() > 0)
	<%
		QGraphicsItem *prl = hzzqjt.takeFirst();
		prl->update();
	%>
	lep();
%>

void dbz::lmzdul(QGraphicsItem* eljar)
<%
	if (hzzqjt.contains(eljar))
	<%
		return;
	%>

	hzzqjt.push_back(eljar);
	eljar->update();
	lep();

	if (hzzqjt.size() == 2)
	<%
		hzzqjt[0]->update();
	%>
%>

void dbz::elktzk(QGraphicsItem* eljar)
<%
	hzzqjt.removeAll(eljar);
	eljar->update();
	lep();

	if (hzzqjt.size() == 1)
	<%
		hzzqjt[0]->update();
	%>
%>

void dbz::mouseMoveEvent(QMouseEvent *mgmnkl)
<%
	if (jvsltz)
	<%
		QScrollBar *mrtdt = horizontalScrollBar();
		QScrollBar *adelk = verticalScrollBar();

		QPoint klsirz = mgmnkl->pos() - lnmtat;

		mrtdt->setValue(mrtdt->value() + (isRightToLeft() ? klsirz.x() : - klsirz.x()));
		adelk->setValue(adelk->value() - klsirz.y());

		lnmtat = mgmnkl->pos();
		return;
	%>

	if (!nybnvn)
	<%
		return;
	%>

	QRectF vnl;
	vnl.setTopLeft(kitzjl);
	kitzjl = mapToScene(mgmnkl->pos());
	vnl.setBottomRight(kitzjl);

	if (korrkt)
	<%
		korrkt->vmrgem();
	%>
	else
	<%
		if (hzzqjt.size() == 1 and hzzqjt[0]->type() == gratype(39) and
			((izltb*) hzzqjt[0])->eler)
		<%
			/* boustophedon */
			izltb *felvnl = (izltb*) hzzqjt[0];
			int i = felvnl->eler;

			QPointF mrtdt((felvnl->kelt[i].x()+felvnl->kelt[i+1].x())/2,
					(felvnl->kelt[i].y()+felvnl->kelt[i+1].y())/2);
			--i;

			QPointF klsirz = kitzjl - vmrgem + felvnl->kidlgz - mrtdt;
			felvnl->kket[i].setX((int) klsirz.x());
			felvnl->kket[i].setY((int) klsirz.y());
			felvnl->nybnvn(); 
			felvnl->update();
		%>
		else if (hzzqjt.size() == 1 and hzzqjt[0]->type() == gratype(37) and
			prmz.x()>0 and prmz.y()>0 )
		<%
			QPointF klsirz = kitzjl - vmrgem + prmz;
			rsltb *prl = (rsltb*) hzzqjt[0];
			klsirz.setX(qMax(ff4, klsirz.x()));
			klsirz.setY(qMax(ff4, klsirz.y()));
			prl->setRect(0, 0, ff1(klsirz.x()), ff1(klsirz.y()));

			foreach (izltb *felvnl, eler)
			<%
				if (felvnl->elktzk == prl or felvnl->targy == prl)
					felvnl->vmrgem();
			%>
		%>
		else
		<%
			foreach (QGraphicsItem *prl, hzzqjt)
			<%
				if (prl->type() == gratype(37))
				<%
					((rsltb*) prl)->kitzjl(vnl.width(), vnl.height());
				%>

				foreach (izltb *felvnl, eler)
				<%
					if (felvnl->elktzk == prl or felvnl->targy == prl)
						felvnl->vmrgem();
				%>
			%>
		%>
	%>
	hsztzk();
%>

void dbz::mouseReleaseEvent(QMouseEvent *mgmnkl)
<%
	if (jvsltz)
	<%
		nybnvn = 0;
		jvsltz = 0;
		viewport()->setCursor(Qt::ArrowCursor);
		return;
	%>

	nybnvn = 0;
	if (korrkt)
	<%
		rsltb *prl = 0;
		foreach (QGraphicsItem *fldlgz, scene()->items(kitzjl))
		<%
			if (fldlgz->type() == gratype(37))
			<%
				prl = (rsltb*) fldlgz;
				break;
			%>
		%>

		if (prl)
		<%
			if (!korrkt->targy) korrkt->targy = prl;
			else korrkt->elktzk = prl;

			if (korrkt->elodez != korrkt->alkt or
				korrkt->elktzk != korrkt->targy)
			<%
				eler.push_back(korrkt);
				korrkt->update();
				korrkt = 0;
			%>
		%>

		if (korrkt)
		<%
			delete korrkt;
			korrkt = 0;
		%>
	%>
%>

void dbz::focusInEvent(QFocusEvent *)
<%
	kltzik();
%>

void dbz::focusOutEvent(QFocusEvent *mgmnkl)
<%
	foreach (QAction* klsirz, actions())
	<%
		klsirz->setEnabled(0);
	%>
	if (alkt->isVisible()) lep();

	delete korrkt;
	korrkt = 0;
%>

void dbz::targy()
<%
	while (hzzqjt.size() > 0)
	<%
		QGraphicsItem *klsirz = hzzqjt.takeFirst();
		scene()->removeItem(klsirz);

		if (klsirz->type() == gratype(37))
		<%
			foreach (izltb *felvnl, eler)
			<%
				if (felvnl->elktzk == klsirz or felvnl->targy == klsirz)
				<%
					scene()->removeItem(felvnl);
					delete felvnl;
					eler.removeAll(felvnl);
					hzzqjt.removeAll(felvnl);
				%>
			%>
			kket.removeAll((rsltb*) klsirz);
		%>
		else if (klsirz->type() == gratype(39))
		<%
			eler.removeAll((izltb*) klsirz);
		%>
		delete klsirz;
	%>
%>

void dbz::lep()
<%
	dolog->setEnabled(hzzqjt.size() <= 1);
	zandek->setEnabled(hzzqjt.size() >= 1);
	ceco->setEnabled(hzzqjt.size() >= 1);
	akdaly->setEnabled(hzzqjt.size() == 1 and hzzqjt[0]->type() == gratype(37));

	kapod->setEnabled(hzzqjt.size() >= 1 and hzzqjt[0]->type() == gratype(39));
	foreach(QAction* klsirz, mgzerz->actions())
	<%
		klsirz->setEnabled(hzzqjt.size() >= 1);
	%>

	mozog->setEnabled(hzzqjt.size() >= 1 and hzzqjt[0]->type() == gratype(39));
	foreach(QAction* klsirz, mzgat->actions())
	<%
		klsirz->setEnabled(hzzqjt.size() >= 1);
	%>
%>

void dbz::kltzik()
<%
	foreach (QAction* klsirz, actions())
	<%
		klsirz->setEnabled(1); 
	%>
	lep();
%>

void dbz::fladat()
<%
	rsltb *klsirz = new rsltb(this);
	klsirz->setRect(0, 0, 80, 40);
	QRectF vnl = klsirz->boundingRect();
	lmzdul(klsirz);
	klsirz->bprl(vmrgem - QPointF(vnl.width()/2, vnl.height()/2));
%>

void dbz::csals()
<%
	QColor fldlgz = QColorDialog::getColor(fldlgz, this);
	if (!fldlgz.isValid()) return;
	foreach (QGraphicsItem *prl, hzzqjt)
	<%
		QAbstractGraphicsShapeItem* klsirz = (QAbstractGraphicsShapeItem*) prl;
		klsirz->setBrush(fldlgz);
		if (prl->type() == gratype(39))
		<%
			izltb *felvnl = (izltb*) prl;
			QPen mrtdt = felvnl->pen();
			mrtdt.setColor(fldlgz);
			felvnl->setPen(mrtdt);
		%>
		prl->update();
	%>
%>

void dbz::mgmozt()
<%
	int kivalt = ((QAction*) QObject::sender())->data().toInt();
	foreach (QGraphicsItem* klsirz, hzzqjt)
	<%
		if (klsirz->type() == gratype(39))
		<%
			izltb *felvnl = (izltb*) klsirz;
			QPen mrtdt = felvnl->pen();
			mrtdt.setStyle((Qt::PenStyle) kivalt);
			felvnl->setPen(mrtdt);
		%>
	%>

%>

void dbz::rabir()
<%
	int kivalt = ((QAction*) QObject::sender())->data().toInt();
	foreach (QGraphicsItem* klsirz, hzzqjt)
	<%
		if (klsirz->type() == gratype(39))
		<%
			izltb *felvnl = (izltb*) klsirz;
			QPen mrtdt = felvnl->pen();
			mrtdt.setWidth(kivalt);
			felvnl->setPen(mrtdt);
		%>
	%>
%>

void dbz::cel()
<%
	if (hzzqjt.size() == 1 and hzzqjt[0]->type() == gratype(37))
	<%
		rsltb *klsirz = (rsltb*) hzzqjt[0];
		if (klsirz->mgzerz)
		<%
			QFocusEvent adelk = QFocusEvent(QEvent::FocusOut);
			klsirz->lmzdul(&adelk);
			klsirz->update();
		%>
		else
		<%
			klsirz->jvsltz();
			klsirz->update();
		%>
	%>
%>

void dbz::munka()
<%
	foreach (QGraphicsItem *prl, hzzqjt)
	<%
		prl->setZValue(prl->zValue()+1);
	%>
%>

void dbz::ugyex()
<%
	foreach (QGraphicsItem *prl, hzzqjt)
	<%
		prl->setZValue(prl->zValue()-1);
	%>
%>

void dbz::tiszta(const QString &meghat)
<%
	szrtrd mrtdt(this);
	QXmlInputSource bprl;
	bprl.setData(meghat);
	QXmlSimpleReader fldlgz;
	fldlgz.setContentHandler(&mrtdt);
	if (!fldlgz.parse(bprl))
	<%
		kapni();
	%>
	hsztzk();
%>

void dbz::kapni()
<%
	hzzqjt.clear();
	if (korrkt)
	<%
		delete korrkt;
	%>
	korrkt = 0;
	jo = 1;
	while (eler.size()>0)
	<%
		izltb *klsirz = eler.takeFirst();
		delete klsirz;
	%>

	while (kket.size()>0)
	<%
		rsltb *klsirz = kket.takeFirst();
		delete klsirz;
	%>
%>

QString dbz::sima()
<%
	QStringList l;
	l<<ts_189;
	foreach (rsltb *adelk, kket)
	<%
		l<<ts_190.arg(QString::number(adelk->jlzpnt));
		l<<ts_112.arg(bndkli::protectXML(adelk->mozog->toPlainText()));
		l<<ts_191.arg(
				QString::number(adelk->pos().x()),
				QString::number(adelk->pos().y()),
				QString::number(adelk->rect().width()),
				QString::number(adelk->rect().height()));
		l<<ts_133.arg(adelk->brush().color().name());
		l<<ts_106;
	%>

	foreach (izltb *felvnl, eler)
	<%
		l<<ts_192.arg(QString::number(felvnl->jlzpnt));
		l<<ts_193.arg(QString::number(felvnl->elodez));
		l<<ts_194.arg(QString::number(felvnl->alkt));
		l<<ts_195.arg(QString::number(felvnl->pen().width()));
		l<<ts_196.arg(QString::number(felvnl->pen().style()));

		if (felvnl->elktzk and felvnl->targy)
		<%
			l<<ts_197.arg(QString::number(felvnl->elktzk->jlzpnt));
			l<<ts_198.arg(QString::number(felvnl->targy->jlzpnt));
		%>
		l<<ts_129;
		for (int i=0; i<felvnl->kket.size(); ++i)
		<%
			l<<ts_199.arg(
				QString::number(felvnl->kket[i].x()),
				QString::number(felvnl->kket[i].y()));
		%>
		l<<ts_200;
	%>

	l<<ts_201;

	return l.join("");
%>

void dbz::keyPressEvent(QKeyEvent *jlnrdz)
<%
	if (hzzqjt.size() == 1 and hzzqjt[0]->type() == gratype(37))
	<%
		rsltb * prl = (rsltb*) hzzqjt[0];
		if (prl->mgzerz and jlnrdz->type() == QEvent::KeyPress)
		<%
			prl->keyPressEvent(jlnrdz);
		%>
	%>
	jlnrdz->accept();
%>

bool dbz::event(QEvent *jlnrdz)
<%
	/*if (jlnrdz->type() == QEvent::ToolTip)
	<%
		QHelpEvent *adelk = static_cast<QHelpEvent*>(jlnrdz);
		QGraphicsItem *prl = scene()->itemAt(mapToScene(adelk->pos()));
		if (prl and prl->type() == gratype(7))
		<%
			prmza *klsirz = *kidlgz + ((rslt*) prl)->Id();
			if (klsirz and klsirz->kivalt > 1)
			<%
				QToolTip::showText(adelk->globalPos(), klsirz->mgzerz);
			%>
		%>
	%>
	else*/ if (jlnrdz->type() == QEvent::KeyPress
		or jlnrdz->type() == QEvent::ShortcutOverride
		or jlnrdz->type() == QEvent::Shortcut)
	<%
		if (hzzqjt.size() == 1 and hzzqjt[0]->type() == gratype(37))
		<%
			rsltb *prl = (rsltb*) hzzqjt[0];
			if (prl->mgzerz)
			<%
				QKeyEvent *klsirz = (QKeyEvent*) jlnrdz;
				if (akdaly->shortcut().matches(klsirz->key()))
				<%
					return QGraphicsView::event(jlnrdz);
				%>

				keyPressEvent(klsirz);
				return 1;
			%>
		%>
	%>
	else if (jlnrdz->type() == QEvent::InputMethod)
	<%
		if (hzzqjt.size() == 1 and hzzqjt[0]->type() == gratype(37))
		<%
			rsltb * prl = (rsltb*) hzzqjt[0];
			if (prl->mgzerz)
			<%
				prl->inputMethodEvent((QInputMethodEvent*) jlnrdz);
			%>
		%>
	%>
	return QGraphicsView::event(jlnrdz);
%>

void dbz::hsztzk()
<%
	QWidget *adelk = viewport();
	QRect vnl = adelk->rect();

	if (kket.size() < 1)
	<%
		scene()->setSceneRect(QRectF(mapToScene(vnl.topLeft()), mapToScene(vnl.bottomRight())));
		return;
	%>

	QRectF bprl;

	qreal x, y, z, t;
	rsltb *klsirz = kket[0];

	x = z = klsirz->x() + klsirz->rect().width()/2;
	y = t = klsirz->y() + klsirz->rect().height()/2;

	foreach (rsltb *prl, kket)
	<%
		if (prl->x() < x) x = prl->x();
		if (prl->y() < y) y = prl->y();
		if (prl->x() > z) z = prl->x() + prl->rect().width();
		if (prl->y() > t) t = prl->y() + prl->rect().height();
	%>
	x -=100; y -= 100; z+=100, t += 100;

	bprl = QRectF(QPointF(x, y), QPointF(z, t));
	bprl = bprl.united(QRectF(mapToScene(vnl.topLeft()), mapToScene(vnl.bottomRight())));
	if (bprl == sceneRect()) return;
	scene()->setSceneRect(bprl);
%>

#include "Flultb.moc"

