#sem:name: Web document
#sem:tip: Generates a simple html document with a stylesheet

# Thomas Nagy, 2007 (ita)

# html_exclude_table
# html_exclude_pic
# html_picstyle
# html_piccaptionstyle
# html_picdivstyle

import os, shutil, time

outdir = sembind.get_var('outdir')+'/'+sembind.get_var('pname')

settings = {
'doc_content':'',
'doc_title':'',
}
add_globals(settings)

try:
	tm = time.strftime('.%d-%b-%y--%H-%M-%S', time.gmtime(os.stat(outdir).st_mtime))
	os.rename(outdir, outdir+tm)
except OSError:
	pass

try:
	os.makedirs(outdir)
except OSError:
	debug("Cannot create folder " + outdir)

# copy the pictures
cwd = os.getcwd()
os.chdir(sembind.get_var('temp_dir'))
pics = {} # map the id to the picture
lst = os.listdir('.')
for i in lst:
	if i.rfind('pic-') > -1:
		pics[ i.replace('pic-', '').split('.')[0] ] = i
		shutil.copy2(i, outdir)
os.chdir(cwd)

buf = []
out = buf.append

def p(s):
	return sembind.protectHTML(s)

def x(s):
	return sembind.protectXML(s)

def print_nodes(node, niv, lbl_lst):

	lbl = ".".join(lbl_lst)
	if niv == 0:
		settings['doc_title'] = node.get_val('summary')
	elif niv in range(5):
		out('<h%d><span class="show_niv">%s</span>%s</h%d>\n' % (niv, lbl, node.get_val('summary'), niv))

	y = node.get_val('text')
	out(p(y))

	# TODO does not exist anymore
	n = node.link_count()
	for i in range(n):
		loc = x(node.link_location(i))
		cap = x(node.link_caption(i))
		v = "<a class='sem_href' href='%s'>%s</a>" % (loc, cap)
		out(v)

	rows = node.num_rows()
	cols = node.num_cols()
	if rows>0 and cols>0 and not node.get_var('exclude_table'):

		caption = node.get_var('tbl_caption')
		if not caption: caption = '(TODO: set a caption for this table! -> var tbl_caption)'

		out('\n')
		out('<table class="sem_table" cellspacing="0px" cellpadding="0px">\n')
		out('<caption>%s</caption>\n' % x(caption))
		out('<tbody>\n')
		for i in range(rows):
			out('\t<tr>\n')
			for j in range(cols):
				if i>0 and j>0:
					out('\t\t<td>%s</td>\n' % x(node.get_cell(i, j)))
				else:
					out('\t\t<th>%s</th>\n' % x(node.get_cell(i, j)))
			out('\t</tr>\n')

		out('</tbody>\n')
		out('</table>\n')

	out('\n')


	id = node.get_val('id')
	if id in pics and not node.get_var('exclude_pic'):

		caption = node.get_var('pic_caption')
		if not caption: caption = '(TODO: set a caption for this picture using pic_caption!)'

		style = node.get_var('picstyle')
		if not style:
			w = int(node.get_val('pic_w'))
			h = int(node.get_val('pic_h'))
			if w > 800: style = " style='width:800px;'"

		divstyle = node.get_var('picdivstyle')
		#captionstyle = node.get_var('piccaptionstyle')

		src = pics[id]
		out('<p><div class=\"img\" %s><img src=\"%s\" alt=\"%s\" title=\"%s\" %s></div></p>\n'
			% (divstyle, src, x(caption), x(caption), style))

	num = node.child_count()
	for i in range(num):
		print_nodes(node.child_num(i), niv+1, lbl_lst+[str(i+1)])

# the main document
print_nodes(Root(), 0, []);
settings['doc_content'] = "".join(buf)

# now write the document
transform("/html/index.html", outdir+'/index.html', settings)

# css file
shutil.copy2(TEMPLATE_DIR+'/html/def.css', outdir)

# okay, code generation has worked
visualize('html', outdir+'/index.html')

