#include <qdatetime.h>

#include "alarmcl.h"
#include "alarmsv.h"
#include "config.h"
#include "dialogfonts.h"

extern AlarmSv *alarmServer;
extern Config *defCfg;

AlarmCl::AlarmCl(Note *p, NoteConfig *n) : 
	QWidget(p, 0,	WType_Dialog | WStyle_DialogBorder | WShowModal | WDestructiveClose), parent(p), 
	cfg(n) {
	
	// Main layout
	layout = new QGridLayout(this, 2, 2, 10);
	buttonOk = new QPushButton("OK", this);
	buttonOk->setFont(font_normtext);
	buttonCancel = new QPushButton("Cancel", this);
	buttonCancel->setFont(font_normtext);
	btgrp = new QButtonGroup(QString("Enable alarm for ") + cfg->name + QString(":"), this);
	btgrp->setFont(font_normtext);
	btgrp->setCheckable(true);
	layout->addMultiCellWidget(btgrp, 0, 0, 0, 1, AlignCenter);
	layout->addWidget(buttonOk, 1, 0, AlignCenter);
	layout->addWidget(buttonCancel, 1, 1, AlignCenter);
	
	// Sub layout
	subLayout = new QGridLayout(btgrp, 5, 11, 2);
	spinYear = new QSpinBox(btgrp);
	spinMonth = new SpinBox(btgrp);
	spinDay = new SpinBox(btgrp);
	spinDay->useDayNames = true;
	spinHour = new SpinBox(btgrp);
	spinMin = new SpinBox(btgrp);
	l1 = new QLabel("-", btgrp);
	l2 = new QLabel("-", btgrp);
	l3 = new QLabel(":", btgrp);
	l4 = new QLabel("Date", btgrp);
	l5 = new QLabel("Time", btgrp);
	spinYear->setFont(font_normtext);
	spinMonth->setFont(font_normtext);
	spinDay->setFont(font_normtext);
	spinHour->setFont(font_normtext);
	spinMin->setFont(font_normtext);
	l1->setFont(font_normtext);
	l2->setFont(font_normtext);
	l3->setFont(font_normtext);
	l4->setFont(font_heading);
	l5->setFont(font_heading);
	subLayout->setRowSpacing(0, 20);
	subLayout->setColSpacing(0, 10);
	subLayout->addMultiCellWidget(l4, 1, 1, 1, 5, AlignCenter);
	subLayout->addMultiCellWidget(l5, 1, 1, 7, 9, AlignCenter);
	subLayout->setRowSpacing(2, 10);
	subLayout->addWidget(spinYear, 3, 1, AlignCenter);
	subLayout->addWidget(l1, 3, 2, AlignCenter);
	subLayout->addWidget(spinMonth, 3, 3, AlignCenter);
	subLayout->addWidget(l2, 3, 4, AlignCenter);
	subLayout->addWidget(spinDay, 3, 5, AlignCenter);
	subLayout->setColSpacing(6, 10);
	subLayout->addWidget(spinHour, 3, 7, AlignCenter);
	subLayout->addWidget(l3, 3, 8, AlignCenter);
	subLayout->addWidget(spinMin, 3, 9, AlignCenter);
	subLayout->setColSpacing(10, 10);
	subLayout->setRowSpacing(4, 10);
	
	
	// Set min and max values
	spinYear->setMinValue(1970);
	spinYear->setMaxValue(9999);
	spinMonth->setMaxValue(12);
	spinMonth->setMinValue(0);
	spinDay->setMinValue(-7);
	spinHour->setMinValue(-1);
	spinHour->setMaxValue(23);
	spinMin->setMinValue(-1);
	spinMin->setMaxValue(59);
	spinYear->setSpecialValueText("N/A");
	spinMonth->setSpecialValueText("N/A");
	spinDay->setSpecialValueText("N/A");
	spinHour->setSpecialValueText("N/A");
	spinMin->setSpecialValueText("N/A");
	
	// Load data
	spinYear->setValue(cfg->alarmData.year);
	spinMonth->setValue(cfg->alarmData.month);
	setDayMax();
	spinDay->setValue(cfg->alarmData.day);
	spinHour->setValue(cfg->alarmData.hour);
	spinMin->setValue(cfg->alarmData.minute);
	btgrp->setChecked(cfg->alarmData.enabled);
	
	// Connect signals
	connect(spinYear, SIGNAL(valueChanged(int)), SLOT(setDayMax()));
	connect(spinMonth, SIGNAL(valueChanged(int)), SLOT(setDayMax()));
	connect(buttonOk, SIGNAL(clicked()), SLOT(clickOk()));
	connect(buttonCancel, SIGNAL(clicked()), SLOT(clickCancel()));
	
	// show
	show();
}

AlarmCl::~AlarmCl() {
	delete layout;
	delete buttonCancel;
	delete buttonOk;
	delete btgrp;
}

void AlarmCl::setDayMax() {
	switch(spinMonth->value()) {
		case 2:
			if(spinYear->value() == 1970)
				spinDay->setMaxValue(29);
			else
				spinDay->setMaxValue(QDate::leapYear(spinYear->value()) ? 29 : 28);
			
			break;
		case 4:
		case 6:
		case 9:
		case 11:
			spinDay->setMaxValue(30);
			break;
		
		default:
			spinDay->setMaxValue(31);
	}
	
	if(spinDay->value() > spinDay->maxValue())
		spinDay->setValue(spinDay->maxValue());
}

void AlarmCl::clickCancel() {
	close();
}

void AlarmCl::clickOk() {
	cfg->alarmData.year = spinYear->value();
	cfg->alarmData.month = spinMonth->value();
	cfg->alarmData.day = spinDay->value();
	cfg->alarmData.hour = spinHour->value();
	cfg->alarmData.minute = spinMin->value();
	cfg->alarmData.enabled = btgrp->isChecked();
	parent->saveData();
	alarmServer->update();
	close();	
}

void AlarmCl::keyPressEvent (QKeyEvent *e) {
	if(e->key() == Qt::Key_Escape) {
		buttonCancel->animateClick();
		e->accept();
	}
	else if(e->key() == Qt::Key_Enter) {
		buttonOk->animateClick();
		e->accept();
	}
	else
		e->ignore();
}
