#ifndef alarmclh
#define alarmclh

#include <qwidget.h>
#include <qevent.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <qcombobox.h>
#include <qspinbox.h>

#include "noteconfig.h"
#include "note.h"
#include "spinbox.h"

class AlarmCl : public QWidget {
	Q_OBJECT

	private:
		Note *parent;
		NoteConfig *cfg;
		QGridLayout *layout, *subLayout;
		QPushButton *buttonOk, *buttonCancel;
		QButtonGroup *btgrp;
		QSpinBox *spinYear;
		SpinBox *spinDay, *spinMonth, *spinHour, *spinMin;
		QLabel *l1, *l2, *l3, *l4, *l5;
	
	public:
		AlarmCl(Note *p, NoteConfig *n);
		~AlarmCl();
		void keyPressEvent (QKeyEvent *e);
	
	public slots:
		void setDayMax();
		void clickCancel();
		void clickOk();
};

#endif
