#ifndef alarmsvh
#define alarmsvh

#include <qtimer.h>
#include <qprocess.h>
#include <qstring.h>

#include <map>

#include "alarmtimestamp.h"

class AlarmProcess : QProcess {
	Q_OBJECT
	
	private slots:
		void exitHandler();
	
	public:
		AlarmProcess(const QString fileName);
		~AlarmProcess();
};


class AlarmSv : public QTimer {
	Q_OBJECT
		
	private:
		QString dateTimeStamp;
		std::multimap<QString, AlarmTimeStamp > alarmList;

	private slots:
		void handler();
		
		
	public:
		AlarmSv();
		void update(bool initalCheck = false);
		bool histCheck(AlarmTimeStamp *c, AlarmTimeStamp i);
		bool checkDate(AlarmTimeStamp *c, AlarmTimeStamp i);
		bool checkMinute(AlarmTimeStamp *c, AlarmTimeStamp i);
		bool checkHour(AlarmTimeStamp *c, AlarmTimeStamp i);
		bool checkDay(AlarmTimeStamp *c, AlarmTimeStamp i);
		bool checkMonth(AlarmTimeStamp *c, AlarmTimeStamp i);
};

#endif
