#include <qapplication.h>
#include <qstring.h>

#include "config.h"
#include "xpms_buttonclose.h"

buttonClose::buttonClose(QWidget *p) : 
	QLabel(p), 
	icon_up (new QPixmap()),
	icon_down (new QPixmap()),
	mousePressed(false) { }

buttonClose::~buttonClose() {
	delete icon_up;
	delete icon_down;
}

void buttonClose::updateColors(QColor *fgCol, QColor *bgCol) {
	QString stringFgCol(QString("0 c ") + fgCol->name());

	xpm_close_up[2] = (char *) stringFgCol.ascii();
	xpm_close_down[2] = (char *) stringFgCol.ascii();

	// Delete old
	delete icon_down;
	delete icon_up;
	
	icon_up = new QPixmap((const char**) xpm_close_up);
	icon_down = new QPixmap((const char**) xpm_close_down);

	if(mousePressed)
		setPixmap(*icon_down);
	else
		setPixmap(*icon_up);
	
	setBackgroundColor(*bgCol);
}

void buttonClose::mousePressEvent(QMouseEvent *e) {
	if(e->button() == LeftButton) {
		mousePressed = true;
		setPixmap(*icon_down);
		update();
		e->accept();
	}
}

void buttonClose::mouseReleaseEvent(QMouseEvent *e) {
	if (mousePressed && e->button() == LeftButton && mouseInsideWidget(e)) {
		parentWidget()->close();
		e->accept();
	}
	else
		e->ignore();
	
	mousePressed = false;
}

void buttonClose::mouseMoveEvent(QMouseEvent *e) {
	if (mousePressed) {
		setPixmap(mouseInsideWidget(e) ? *icon_down : *icon_up);
		update();
		e->accept();
	}
	else
		e->ignore();	
}

bool buttonClose::mouseInsideWidget(QMouseEvent *e) {
	return e->x() > -1 && e->y() > -1 && e->x() < width() && e->y() < height();
}
