#ifndef config_header
#define config_header

#include <qwidget.h>
#include <qfont.h>
#include <qcolor.h>
#include <qstringlist.h>
#include <qtabwidget.h>
#include <qpushbutton.h>
#include <qevent.h>
#include <qlayout.h>

#include "snotes.h"
#include "tabWidgets.h"
#include "alarmtimestamp.h"

class tabIcon;
class tabNotes;
class tabCommands;

class Config : public QWidget {
	Q_OBJECT
	
	enum Flags {FLAG_UNKNOWN, FLAG_FONT, FLAG_COL, FLAG_GEO, FLAG_OPT, FLAG_CMDS, FLAG_WMHINTS, FLAG_ALARM};
	
	private:
		QGridLayout *layout;
		QTabWidget *tabBar;
		QPushButton *buttonOK, *buttonApply, *buttonDefaults, *buttonCancel;
		tabIcon *tab1;
		tabNotes *tab2;
		tabCommands *tab3;
	
		void setupData(Config *c);
		void setupWidgets();
	
	public:
		QFont fontMenu, fontBody, fontTitle, fontHeading;
		int noteWidth, noteHeight, iconPosX, iconPosY;
		QColor colorBodyBg, colorBodyFg, colorTitleBg, colorTitleFg;
		int noteLayer, iconLayer; // 0 = normal, 1 = above, 2 = below
		bool iconSavePos, iconSkipTaskbar, iconSticky;
		bool noteAutoIndent, noteSkipTaskbar, noteSticky;
		int noteTabSize;
		QString alarmCmd;
		AlarmTimeStamp dateTimeTag;
		bool popupNote;
		QStringList cmdPipe, cmdRun;

		QString prgPath;

		Snotes *pSnotes;

		Config();
		~Config();
		bool load();
		bool save();
		void setDefaults(Config *obj);
		void setpSnotes(Snotes *p);
		void hide();

		static bool parseConfig(QString * inp, bool * out);
		static bool parseConfig(QString * inp, QStringList * list, QColor * out);
		static bool parseConfig(QString * inp, QFont * out);
		static bool parseConfig(QString * inp, int * out);
		static bool parseConfig(QString *inp, QWidget *out);
		static bool Config::parseConfig(QString *inp, AlarmTimeStamp *out);

		void keyPressEvent (QKeyEvent *e);
		
	public slots:
		void show();
		void clickOK();
		void clickApply();
		void clickDefaults();
		void clickCancel();
		void polish();
};

#endif
