/****************************************************************
**
** Sticky Notes by JVC (C) November 2004
**
****************************************************************/

#include <qapplication.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qlabel.h>
#include <qdir.h>

#include <signal.h>

#include "snotes.h"
#include "main.h"

#define definedialogfonts
#include "dialogfonts.h"

int main( int argc, char **argv )
{
	signal(SIGTERM, handle);
	signal(SIGINT, handle);

	QApplication a(argc, argv);
	
	defCfg = new Config;
	
	if (setup(defCfg)) {
		Snotes note;
		return note.run();
    }
    
    return -1;
}

bool setup(Config * cfg) {
	QDir qd = QDir::home();

	if (qd.isRoot()) {
		qWarning("Got root when requesting home dir.\nCheck that your HOME-environment variable is set.");
		return false;
	}
	
	if (!qd.exists(".snotes", false)) {
		qWarning("%s does not exists. Creating dir...", (qd.absPath() + "/.snotes/").ascii());
		if(!qd.mkdir(qd.absPath() + "/.snotes/")) {
			qWarning("Could not create %s. Exiting...", (qd.absPath() + "/.snotes/").ascii());
			return false;
		}
	}
	
	cfg->prgPath = qd.absPath() + "/.snotes/";
	
	if(!cfg->load()) {
		qWarning("An error happened while loading or parsing the configuration file.\nExiting...");
		return false;
	}
	
	return true;
}

void handle(int n) {
	qApp->mainWidget()->close();
	qApp->processEvents();
	exit(n);
}
