#include <qapplication.h>

#include "xpms_menu.h"
#include "config.h"
#include "menu.h"

extern Config *defCfg;

Menu::Menu(QWidget *parent) : QPopupMenu (parent) {
	QPixmap micon1(xpm_menu_new_note);
	QPixmap micon2(xpm_menu_new_note_clipboard);
	QPixmap micon3(xpm_menu_prefs);
	QPixmap micon4(xpm_menu_about);
	QPixmap micon5(xpm_menu_about_qt);
	QPixmap micon6(xpm_menu_quit);
	
	setFont(defCfg->fontMenu);
	
	heading =  new QLabel("Sticky Notes", this);
	heading->setAlignment(AlignHCenter);
	
	updateFonts();
	
	insertItem (heading);
	insertItem (micon1, "&New note", parent, SLOT(new_note()), CTRL+Key_N);
	insertItem (micon2, "New note from &Selection...", parent, SLOT(new_note_clipboard()), CTRL+Key_S);
	insertSeparator();
	insertItem (micon3, "&Preferences", parent, SLOT(prefs()), CTRL+Key_P);
	insertSeparator();
	insertItem (micon4, "About", parent, SLOT(about()));
	insertItem (micon5, "About QT", parent, SLOT(aboutqt()));
	insertSeparator();
	insertItem (micon6, "&Quit", qApp, SLOT(quit()), CTRL+Key_Q);
}

void Menu::updateFonts() {
	heading->setFont(defCfg->fontHeading);
	setFont(defCfg->fontMenu);
}
