#ifndef noteh
#define noteh

#include <qstring.h>
#include <qcolor.h>
#include <qlabel.h>
#include <qwidget.h>
#include <qlayout.h>
#include <qpoint.h>
#include <qtimer.h>

class Snotes;
class NoteMenu;
class NoteHeading;
class Note;

#include "noteconfig.h"
#include "config.h"
#include "snotes.h"
#include "notemenu.h"
#include "buttonClose.h"
#include "textedit.h"
#include "alarmtimestamp.h"

class buttonClose;
class TextEdit;
class NoteConfig;
	
enum mouseDragFlags {Lifted, Move, ResizeTL, ResizeTR, ResizeBL, ResizeBR, ResizeT, ResizeB, ResizeL, ResizeR};

class Note : public QWidget {
	Q_OBJECT
	
	private:
		// Pointers
		static Note *first, *last;
		Note *next, *prev;
		QTimer flashTimer;
		int flashCounter;
		static const int flashNum = 10;

		NoteConfig *myConfig;
		QLabel *title;
		buttonClose *closeButton;
		TextEdit *body;
		NoteMenu *menu;
		QGridLayout *widgetLayout;

		QPoint mouseOffset;  // Mouse offset when moving and dragging windows
		QRect windowOffset;  // Window offset for ditto
		static bool appIsClosing;
		bool flagNoSave;
		mouseDragFlags flagMouseDrag;
	
		mouseDragFlags getMouseMode(QMouseEvent *e);
	
	public:
		Note(QString *filename, QString *newName = NULL, bool dataFromClipboard = false, QString content = QString());
		~Note();
        void resizeEvent(QResizeEvent *);
		
		// Div. andre func
        void loadData();
        void saveData();
		QString getName();
		bool getAutoIndent();
		void updateConfig();
		void updateColors();
		void updateFromDefaults();
	
        static QString loadNameFromFile(const QString *filename);
        static AlarmTimeStamp loadTimeStampFromFile(const QString *filename);
        static Note * Open(QString *filename, QString *newName = NULL, bool dataFromClipboard = false, QString content = QString());
        static void New(bool dataFromClipboard = false);
        static void New(QString name, const QString &text);
		static void closeAll();
		static void openNotes();
		static bool openOnStart(QString *filename);
		static bool findNote(const QString *filename, Note **ret);
		static void updateAll();

		// Events	
		void mousePressEvent(QMouseEvent *e);
		void mouseMoveEvent(QMouseEvent *e);
		void mouseReleaseEvent(QMouseEvent *e);
		void mouseDoubleClickEvent (QMouseEvent * e);

	public slots:
		void insertDate();
		void pipe();
		void showPrefs();
		void showAlarmCl();
		void rename();
        void Delete();
		void flash();
};

#endif
