#include <map>
#include <qdir.h>

#include "xpms_note_list.h"
#include "config.h"
#include "note.h"
#include "note_list.h"


extern Config *defCfg;


NoteList::NoteList(QWidget *parent) : QPopupMenu (parent), itemIcon(xpm_note_list) {
	setFont(defCfg->fontMenu);
	
	updateList();
}

void NoteList::updateFonts() {
	heading->setFont(defCfg->fontHeading);
	setFont(defCfg->fontMenu);
}

void NoteList::updateList() {
	using namespace std;
	
	multimap<QString, int, less<QString> > nameList;
	multimap<QString, int, less<QString> >::iterator it;
	
	// Clean up	
	clear();
	listFilenames.clear();
	
	// Heading
	heading = new QLabel("Notes", this);
	heading->setAlignment(AlignHCenter);
	heading->setFont(defCfg->fontHeading);
	insertItem (heading);


	QDir browser(defCfg->prgPath, QString("note.*"), QDir::Name, QDir::Files);
	
	for (unsigned int j = 0; j < browser.count(); j++) {
		nameList.insert(make_pair(Note::loadNameFromFile(&browser[j]), j));
		listFilenames << browser[j];
	}

	for (it = nameList.begin(); it != nameList.end(); it++)
		insertItem(itemIcon, (*it).first, this, SLOT(showNote(int)), 0, (*it).second);
}

void NoteList::showNote(int n) {
	QString t = *listFilenames.at(n);
	Note::Open(&t);
}
