#ifndef noteconfig
#define noteconfig

#include <qstring.h>
#include <qfont.h>
#include <qcolor.h>
#include <qtextedit.h>
#include <qwidget.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qevent.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>

#include "config.h"
#include "alarmtimestamp.h"

class Note;

class NoteConfig : public QWidget {
	Q_OBJECT
	
	private:
		Note *parent;
		QGridLayout *layout;
		QGroupBox *groupFonts, *groupColors, *groupOptions, *groupWmHints;
		QGridLayout *layoutFonts, *layoutColors, *layoutOptions, *layoutWmHints;
		QLabel *fontTitleViewer, *fontBodyViewer, *fontLabel1, *fontLabel2;
		QPushButton *fontSetTitle, *fontSetBody;
		QLabel *colorLabel1, *colorLabel2, *colorLabel3, *colorLabel4, *colorLabel5, *colorLabel6;
		QPushButton *colorSetTitleFg, *colorSetBodyFg, *colorSetTitleBg, *colorSetBodyBg;
		QLabel *optionLabel;
		QCheckBox *optionAutoIndent, *optionSkipTaskbar, *optionSticky;
		QSpinBox *optionTabSize;
		QButtonGroup *groupLayer;
		QRadioButton *optionLayerNormal, *optionLayerAbove, *optionLayerBelow;
		QPushButton *buttonOK, *buttonApply, *buttonCancel;
	
		void setupWidgets();
	
	public:
		QString name, filename;
		int tabSize;
		QFont fontTitle, fontBody;
		QColor colorBodyBg, colorBodyFg, colorTitleBg, colorTitleFg;
		bool autoIndent, skipTaskbar, sticky;
		int layer; // 0 = normal, 1 = above, 2 = below
		AlarmTimeStamp alarmData;
		bool flagDefFonts, flagDefCols, flagDefOpt, flagDefWmHints;
		
		NoteConfig(Note *p, const QString *filename);
		void show();
		void hide();
		void keyPressEvent (QKeyEvent *e);
	
	public slots:
		void clickOK();
		void clickApply();
		void clickCancel();
		void showFontTitle();
		void showFontBody();
		void showColorTitleFg();
		void showColorTitleBg();
		void showColorBodyFg();
		void showColorBodyBg();
		void toggleDefFonts(bool i);
		void toggleDefColors(bool i);
		void toggleDefOptions(bool i);
		void toggleDefWmHints(bool i);
};

#endif
